/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.budiyev.android.imageloader.InternalUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class DataUtils {
    private static final String HASH_ALGORITHM_SHA256 = "SHA-256";

    private DataUtils() {
    }

    @NonNull
    public static String generateSHA256(@NonNull String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(HASH_ALGORITHM_SHA256);
            messageDigest.update(string.getBytes());
            return new BigInteger(1, messageDigest.digest()).toString(36);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @WorkerThread
    public static Bitmap loadSampledBitmapFromUri(@NonNull Context context, @NonNull Uri uri, int requiredWidth, int requiredHeight) throws IOException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        InputStream inputStream = null;
        try {
            inputStream = InternalUtils.getDataStreamFromUri(context, uri);
            if (inputStream == null) {
                Bitmap bitmap = null;
                return bitmap;
            }
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        }
        finally {
            InternalUtils.close(inputStream);
        }
        DataUtils.calculateSampleSize(options, requiredWidth, requiredHeight);
        options.inJustDecodeBounds = false;
        inputStream = null;
        try {
            inputStream = InternalUtils.getDataStreamFromUri(context, uri);
            if (inputStream == null) {
                Bitmap bitmap = null;
                return bitmap;
            }
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        finally {
            InternalUtils.close(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @WorkerThread
    public static Bitmap loadSampledBitmapFromUrl(@NonNull String url, int requiredWidth, int requiredHeight) throws IOException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        InputStream inputStream = null;
        try {
            inputStream = InternalUtils.getDataStreamFromUrl(url);
            if (inputStream == null) {
                Bitmap bitmap = null;
                return bitmap;
            }
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        }
        finally {
            InternalUtils.close(inputStream);
        }
        DataUtils.calculateSampleSize(options, requiredWidth, requiredHeight);
        options.inJustDecodeBounds = false;
        inputStream = null;
        try {
            inputStream = InternalUtils.getDataStreamFromUrl(url);
            if (inputStream == null) {
                Bitmap bitmap = null;
                return bitmap;
            }
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        finally {
            InternalUtils.close(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @WorkerThread
    public static Bitmap loadSampledBitmapFromFile(@NonNull File file, int requiredWidth, int requiredHeight) throws IOException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        }
        catch (Throwable throwable) {
            InternalUtils.close(inputStream);
            throw throwable;
        }
        InternalUtils.close(inputStream);
        DataUtils.calculateSampleSize(options, requiredWidth, requiredHeight);
        options.inJustDecodeBounds = false;
        inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        finally {
            InternalUtils.close(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @WorkerThread
    public static Bitmap loadSampledBitmapFromFileDescriptor(@NonNull FileDescriptor fileDescriptor, int requiredWidth, int requiredHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(fileDescriptor);
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        }
        catch (Throwable throwable) {
            InternalUtils.close(inputStream);
            throw throwable;
        }
        InternalUtils.close(inputStream);
        DataUtils.calculateSampleSize(options, requiredWidth, requiredHeight);
        options.inJustDecodeBounds = false;
        inputStream = null;
        try {
            inputStream = new FileInputStream(fileDescriptor);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        finally {
            InternalUtils.close(inputStream);
        }
    }

    @Nullable
    @WorkerThread
    public static Bitmap loadSampledBitmapFromResource(@NonNull Resources resources, int resourceId, int requiredWidth, int requiredHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)resources, (int)resourceId, (BitmapFactory.Options)options);
        DataUtils.calculateSampleSize(options, requiredWidth, requiredHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeResource((Resources)resources, (int)resourceId, (BitmapFactory.Options)options);
    }

    @Nullable
    @WorkerThread
    public static Bitmap loadSampledBitmapFromByteArray(@NonNull byte[] byteArray, int requiredWidth, int requiredHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length, (BitmapFactory.Options)options);
        DataUtils.calculateSampleSize(options, requiredWidth, requiredHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length, (BitmapFactory.Options)options);
    }

    private static void calculateSampleSize(@NonNull BitmapFactory.Options options, int requiredWidth, int requiredHeight) {
        int sampleSize = 1;
        int width = options.outWidth;
        int height = options.outHeight;
        int threshold = Math.max(requiredWidth, requiredHeight) / 4;
        while (Math.abs(width - requiredWidth) > threshold && Math.abs(height - requiredHeight) > threshold) {
            width /= 2;
            height /= 2;
            sampleSize *= 2;
        }
        options.inSampleSize = sampleSize;
    }
}

