/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.DataDescriptor;
import com.budiyev.android.imageloader.DataDescriptorFactory;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.ImageLoaderBuilder;
import com.budiyev.android.imageloader.ImageLoaderHolder;
import com.budiyev.android.imageloader.ImageRequest;
import com.budiyev.android.imageloader.ImageRequestFactory;
import com.budiyev.android.imageloader.PauseLock;
import com.budiyev.android.imageloader.StorageImageCache;
import java.util.concurrent.ExecutorService;

public final class ImageLoader {
    private final PauseLock mPauseLock = new PauseLock();
    private final ImageCache mMemoryCache;
    private final ImageCache mStorageCache;
    private final ImageRequestFactory mImageRequestFactory;

    ImageLoader(@NonNull Context context, @NonNull ExecutorService executor, @Nullable ImageCache memoryCache, @Nullable ImageCache storageCache) {
        this.mMemoryCache = memoryCache;
        this.mStorageCache = storageCache;
        if (storageCache instanceof StorageImageCache) {
            ((StorageImageCache)storageCache).setExecutor(executor);
        }
        this.mImageRequestFactory = new ImageRequestFactory(context, executor, this.mPauseLock, memoryCache, storageCache);
    }

    @NonNull
    public ImageRequestFactory request() {
        return this.mImageRequestFactory;
    }

    @NonNull
    public <T> ImageRequest<T> request(@NonNull BitmapLoader<T> loader) {
        return this.mImageRequestFactory.custom(loader);
    }

    @NonNull
    public <T> ImageRequest<T> request(@NonNull BitmapLoader<T> loader, @NonNull DataDescriptorFactory<T> factory) {
        return this.mImageRequestFactory.custom(loader, factory);
    }

    public void invalidate(@NonNull DataDescriptor<?> descriptor) {
        ImageCache storageCache;
        String key = descriptor.getKey();
        if (key == null) {
            return;
        }
        ImageCache memoryCache = this.mMemoryCache;
        if (memoryCache != null && descriptor.isMemoryCachingEnabled()) {
            memoryCache.remove(key);
        }
        if ((storageCache = this.mStorageCache) != null && descriptor.isStorageCachingEnabled()) {
            storageCache.remove(key);
        }
    }

    public boolean isLoadingPaused() {
        return this.mPauseLock.isPaused();
    }

    public void setPauseLoading(boolean paused) {
        this.mPauseLock.setPaused(paused);
    }

    public void setInterruptLoadingEarly(boolean interrupt) {
        this.mPauseLock.setInterruptEarly(interrupt);
    }

    public void clearMemoryCache() {
        ImageCache memoryCache = this.mMemoryCache;
        if (memoryCache != null) {
            memoryCache.clear();
        }
    }

    public void clearStorageCache() {
        ImageCache storageCache = this.mStorageCache;
        if (storageCache != null) {
            storageCache.clear();
        }
    }

    public void clearAllCaches() {
        this.clearMemoryCache();
        this.clearStorageCache();
    }

    @NonNull
    public static ImageLoader with(@NonNull Context context) {
        return ImageLoaderHolder.get(context);
    }

    @NonNull
    public static ImageLoaderBuilder builder(@NonNull Context context) {
        return new ImageLoaderBuilder(context);
    }
}

