/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.support.annotation.NonNull;
import com.budiyev.android.imageloader.BitmapLoaders;
import com.budiyev.android.imageloader.DataDescriptors;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.ImageRequest;
import com.budiyev.android.imageloader.PauseLock;
import java.io.File;
import java.io.FileDescriptor;
import java.util.concurrent.ExecutorService;

public final class RequestDataTypeSelector {
    private final Context mContext;
    private final ExecutorService mExecutor;
    private final PauseLock mPauseLock;
    private final Handler mMainThreadHandler;
    private final BitmapLoaders mBitmapLoaders;
    private final DataDescriptors mDataDescriptors;
    private final ImageCache mMemoryCache;
    private final ImageCache mStorageCache;

    RequestDataTypeSelector(@NonNull Context context, @NonNull ExecutorService executor, @NonNull PauseLock pauseLock, @NonNull Handler mainThreadHandler, @NonNull BitmapLoaders bitmapLoaders, @NonNull DataDescriptors dataDescriptors, @NonNull ImageCache memoryCache, @NonNull ImageCache storageCache) {
        this.mContext = context;
        this.mExecutor = executor;
        this.mPauseLock = pauseLock;
        this.mMainThreadHandler = mainThreadHandler;
        this.mBitmapLoaders = bitmapLoaders;
        this.mDataDescriptors = dataDescriptors;
        this.mMemoryCache = memoryCache;
        this.mStorageCache = storageCache;
    }

    @NonNull
    public ImageRequest<Uri> uri() {
        return new ImageRequest<Uri>(this.mContext, this.mExecutor, this.mPauseLock, this.mMainThreadHandler, this.mMemoryCache, this.mStorageCache, this.mBitmapLoaders.uri(), this.mDataDescriptors.uri());
    }

    @NonNull
    public ImageRequest<String> url() {
        return new ImageRequest<String>(this.mContext, this.mExecutor, this.mPauseLock, this.mMainThreadHandler, this.mMemoryCache, this.mStorageCache, this.mBitmapLoaders.url(), this.mDataDescriptors.url());
    }

    @NonNull
    public ImageRequest<File> file() {
        return new ImageRequest<File>(this.mContext, this.mExecutor, this.mPauseLock, this.mMainThreadHandler, this.mMemoryCache, this.mStorageCache, this.mBitmapLoaders.file(), this.mDataDescriptors.file());
    }

    @NonNull
    public ImageRequest<FileDescriptor> fileDescriptor() {
        return new ImageRequest<FileDescriptor>(this.mContext, this.mExecutor, this.mPauseLock, this.mMainThreadHandler, this.mMemoryCache, this.mStorageCache, this.mBitmapLoaders.fileDescriptor(), this.mDataDescriptors.fileDescriptor());
    }

    @NonNull
    public ImageRequest<Integer> resource() {
        return new ImageRequest<Integer>(this.mContext, this.mExecutor, this.mPauseLock, this.mMainThreadHandler, this.mMemoryCache, this.mStorageCache, this.mBitmapLoaders.resource(), this.mDataDescriptors.resource());
    }

    @NonNull
    public ImageRequest<byte[]> byteArray() {
        return new ImageRequest<byte[]>(this.mContext, this.mExecutor, this.mPauseLock, this.mMainThreadHandler, this.mMemoryCache, this.mStorageCache, this.mBitmapLoaders.byteArray(), this.mDataDescriptors.byteArray());
    }
}

