/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.DataUtils;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.Size;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

final class FileBitmapLoader
implements BitmapLoader<File> {
    FileBitmapLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Bitmap load(@NonNull Context context, @NonNull File data, @Nullable Size size) throws Throwable {
        Bitmap bitmap;
        if (size != null) {
            bitmap = DataUtils.loadSampledBitmapFromFile(data, size.getWidth(), size.getHeight());
        } else {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(data);
                bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            }
            catch (Throwable throwable) {
                InternalUtils.close(inputStream);
                throw throwable;
            }
            InternalUtils.close(inputStream);
        }
        if (bitmap == null) return bitmap;
        int rotation = InternalUtils.getExifRotation(data);
        if (rotation == 0) return bitmap;
        return InternalUtils.rotateAndRecycle(bitmap, rotation);
    }
}

