/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.support.annotation.NonNull;
import java.io.OutputStream;
import java.util.Arrays;

final class ByteBuffer
extends OutputStream {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private byte[] mArray;
    private int mSize;

    public ByteBuffer(int size) {
        this.mArray = new byte[size];
    }

    @Override
    public void write(int b) {
        int size = this.mSize;
        int requiredSize = size + 1;
        this.grow(requiredSize);
        this.mArray[size] = (byte)b;
        this.mSize = requiredSize;
    }

    @Override
    public void write(@NonNull byte[] bytes, int offset, int length) {
        int size = this.mSize;
        int requiredSize = size + length;
        this.grow(requiredSize);
        System.arraycopy(bytes, offset, this.mArray, size, length);
        this.mSize = requiredSize;
    }

    @NonNull
    public byte[] getArray() {
        return this.mArray;
    }

    public int getSize() {
        return this.mSize;
    }

    private void grow(int capacity) {
        byte[] array = this.mArray;
        int length = array.length;
        if (capacity > length) {
            if ((length *= 2) < capacity) {
                length = capacity;
            }
            if (length > 0x7FFFFFF7) {
                length = capacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
            }
            this.mArray = Arrays.copyOf(array, length);
        }
    }
}

