/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.AnyThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Px;
import android.widget.ImageView;
import com.budiyev.android.imageloader.BitmapTransformation;
import com.budiyev.android.imageloader.DisplayCallback;
import com.budiyev.android.imageloader.ErrorCallback;
import com.budiyev.android.imageloader.LoadCallback;
import com.budiyev.android.imageloader.LoadImageRequestInternal;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class LoadImageRequest {
    private final Context mContext;
    private Uri mSource;
    private Drawable mPlaceholder;
    private Drawable mErrorDrawable;
    private LoadCallback<Uri> mLoadCallback;
    private DisplayCallback<Uri> mDisplayCallback;
    private ErrorCallback<Uri> mErrorCallback;
    private ImageView mView;
    private List<BitmapTransformation<Uri>> mTransformations;
    private int mRequiredWidth = -1;
    private int mRequiredHeight = -1;
    private boolean mFadeEnabled = true;
    private long mFadeDuration = 200L;
    private float mCornerRadius;

    LoadImageRequest(@NonNull Context context) {
        this.mContext = context.getApplicationContext();
    }

    @NonNull
    public LoadImageRequest from(@Nullable Uri uri) {
        this.mSource = uri;
        return this;
    }

    @NonNull
    public LoadImageRequest from(@NonNull String uri) {
        this.mSource = Uri.parse((String)uri);
        return this;
    }

    @NonNull
    public LoadImageRequest from(@NonNull File file) {
        this.mSource = Uri.fromFile((File)file);
        return this;
    }

    @NonNull
    public LoadImageRequest size(@Px int requiredWidth, @Px int requiredHeight) {
        this.mRequiredWidth = requiredWidth;
        this.mRequiredHeight = requiredHeight;
        return this;
    }

    @NonNull
    public LoadImageRequest roundCorners() {
        this.mCornerRadius = -1.0f;
        return this;
    }

    @NonNull
    public LoadImageRequest roundCorners(float cornerRadius) {
        this.mCornerRadius = cornerRadius;
        return this;
    }

    @NonNull
    public LoadImageRequest placeholder(@Nullable Drawable placeholder) {
        this.mPlaceholder = placeholder;
        return this;
    }

    @NonNull
    public LoadImageRequest errorDrawable(@Nullable Drawable errorDrawable) {
        this.mErrorDrawable = errorDrawable;
        return this;
    }

    @NonNull
    public LoadImageRequest transform(@NonNull BitmapTransformation<Uri> transformation) {
        List<BitmapTransformation<Uri>> transformations = this.mTransformations;
        if (transformations == null) {
            this.mTransformations = transformations = new ArrayList<BitmapTransformation<Uri>>();
        }
        transformations.add(transformation);
        return this;
    }

    @NonNull
    public LoadImageRequest fade() {
        this.mFadeEnabled = true;
        return this;
    }

    @NonNull
    public LoadImageRequest noFade() {
        this.mFadeEnabled = true;
        return this;
    }

    @NonNull
    public LoadImageRequest fade(boolean enabled, long duration) {
        this.mFadeEnabled = enabled;
        this.mFadeDuration = duration;
        return this;
    }

    @NonNull
    public LoadImageRequest onLoaded(@Nullable LoadCallback<Uri> callback) {
        this.mLoadCallback = callback;
        return this;
    }

    @NonNull
    public LoadImageRequest onError(@Nullable ErrorCallback<Uri> callback) {
        this.mErrorCallback = callback;
        return this;
    }

    @NonNull
    public LoadImageRequest onDisplayed(@Nullable DisplayCallback<Uri> callback) {
        this.mDisplayCallback = callback;
        return this;
    }

    @NonNull
    public LoadImageRequest into(@Nullable ImageView view) {
        this.mView = view;
        return this;
    }

    @AnyThread
    public void load() {
        Uri source = this.mSource;
        if (source == null) {
            return;
        }
        new LoadImageRequestInternal(this.mContext, source, this.mRequiredWidth, this.mRequiredHeight, this.mView, this.mPlaceholder, this.mErrorDrawable, this.mTransformations, this.mLoadCallback, this.mDisplayCallback, this.mErrorCallback, this.mFadeEnabled, this.mFadeDuration, this.mCornerRadius).execute();
    }
}

