/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

final class RoundedDrawable
extends Drawable {
    public static final float MAX_RADIUS = -1.0f;
    private final Paint mPaint = new Paint(3);
    private final RectF mDrawRect = new RectF();
    private final Matrix mShaderMatrix = new Matrix();
    private final BitmapShader mShader;
    private final Bitmap mBitmap;
    private final float mCornerRadius;
    private final int mWidth;
    private final int mHeight;

    public RoundedDrawable(@NonNull Resources resources, @NonNull Bitmap bitmap, float cornerRadius) {
        this.mShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        this.mPaint.setShader((Shader)this.mShader);
        this.mBitmap = bitmap;
        int density = resources.getDisplayMetrics().densityDpi;
        this.mWidth = bitmap.getScaledWidth(density);
        this.mHeight = bitmap.getScaledHeight(density);
        this.mCornerRadius = cornerRadius;
    }

    public void draw(@NonNull Canvas canvas) {
        float cornerRadius = this.mCornerRadius;
        if (cornerRadius > 0.5f) {
            canvas.drawRoundRect(this.mDrawRect, cornerRadius, cornerRadius, this.mPaint);
        } else if (cornerRadius == -1.0f) {
            cornerRadius = Math.min(this.mDrawRect.width(), this.mDrawRect.height()) / 2.0f;
            canvas.drawRoundRect(this.mDrawRect, cornerRadius, cornerRadius, this.mPaint);
        } else {
            canvas.drawRect(this.mDrawRect, this.mPaint);
        }
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
        this.invalidateSelf();
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return this.mBitmap.hasAlpha() || this.mPaint.getAlpha() < 255 || this.mCornerRadius > 0.5f ? -3 : -1;
    }

    public int getIntrinsicWidth() {
        return this.mWidth;
    }

    public int getIntrinsicHeight() {
        return this.mHeight;
    }

    protected void onBoundsChange(@NonNull Rect bounds) {
        this.mShaderMatrix.setScale((float)bounds.width() / (float)this.mBitmap.getWidth(), (float)bounds.height() / (float)this.mBitmap.getHeight());
        this.mShader.setLocalMatrix(this.mShaderMatrix);
        this.mDrawRect.set(bounds);
        super.onBoundsChange(bounds);
    }
}

