/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.annotation.SuppressLint;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.AnyThread;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.widget.ImageView;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.BitmapTransformation;
import com.budiyev.android.imageloader.DataDescriptor;
import com.budiyev.android.imageloader.DataUtils;
import com.budiyev.android.imageloader.DisplayCallback;
import com.budiyev.android.imageloader.ErrorCallback;
import com.budiyev.android.imageloader.ErrorDrawableProvider;
import com.budiyev.android.imageloader.ImageLoader;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.LoadCallback;
import com.budiyev.android.imageloader.PlaceholderProvider;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class LoadImageRequestInternal {
    private static final Lock LOADER_LOCK = new ReentrantLock();
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile ImageLoader<Data> sLoader;
    private final Context mContext;
    private final Data mData;
    private final ImageView mView;
    private final PlaceholderProvider<Data> mPlaceholder;
    private final ErrorDrawableProvider<Data> mErrorDrawable;
    private final BitmapTransformation<Data> mTransformation;
    private final LoadCallback<Data> mLoadCallback;
    private final DisplayCallback<Data> mDisplayCallback;
    private final ErrorCallback<Data> mErrorCallback;
    private final boolean mFadeEnabled;
    private final long mFadeDuration;
    private final float mCornerRadius;

    public LoadImageRequestInternal(@NonNull Context context, @NonNull Uri data, int requiredWidth, int requiredHeight, @Nullable ImageView view, @Nullable Drawable placeholder, @Nullable Drawable errorDrawable, @Nullable List<BitmapTransformation<Uri>> transformations, @Nullable LoadCallback<Uri> loadCallback, @Nullable DisplayCallback<Uri> displayCallback, @Nullable ErrorCallback<Uri> errorCallback, boolean fadeEnabled, long fadeDuration, float cornerRadius) {
        this.mContext = context.getApplicationContext();
        this.mData = new Data(data, requiredWidth, requiredHeight);
        this.mView = view;
        this.mPlaceholder = placeholder != null ? new PlaceholderWrapper(placeholder) : null;
        this.mErrorDrawable = errorDrawable != null ? new ErrorDrawableWrapper(errorDrawable) : null;
        this.mTransformation = transformations != null && !transformations.isEmpty() ? new BitmapTransformationWrapper(transformations) : null;
        this.mLoadCallback = loadCallback != null ? new LoadCallbackWrapper(loadCallback) : null;
        this.mDisplayCallback = displayCallback != null ? new DisplayCallbackWrapper(displayCallback) : null;
        this.mErrorCallback = errorCallback != null ? new ErrorCallbackWrapper(errorCallback) : null;
        this.mFadeEnabled = fadeEnabled;
        this.mFadeDuration = fadeDuration;
        this.mCornerRadius = cornerRadius;
    }

    @AnyThread
    public void execute() {
        RequestDataDescriptor descriptor = new RequestDataDescriptor(this.mData);
        ImageLoader<Data> loader = this.getLoader();
        if (this.mView == null) {
            loader.load(descriptor, this.mLoadCallback, this.mErrorCallback);
        } else {
            loader.runOnMainThread(new LoadAction(loader, descriptor, this.mView, this.mPlaceholder, this.mErrorDrawable, this.mTransformation, this.mLoadCallback, this.mDisplayCallback, this.mErrorCallback, this.mFadeEnabled, this.mFadeDuration, this.mCornerRadius));
        }
    }

    @NonNull
    private ImageLoader<Data> getLoader() {
        ImageLoader<Data> loader = sLoader;
        if (loader == null) {
            LOADER_LOCK.lock();
            try {
                loader = sLoader;
                if (loader == null) {
                    loader = ImageLoader.builder(this.mContext).custom(new RequestBitmapLoader()).memoryCache().storageCache().build();
                    this.mContext.registerComponentCallbacks((ComponentCallbacks)new ClearMemoryCacheCallbacks());
                    sLoader = loader;
                }
            }
            finally {
                LOADER_LOCK.unlock();
            }
        }
        return loader;
    }

    private static final class DisplayCallbackWrapper
    implements DisplayCallback<Data> {
        private final DisplayCallback<Uri> mCallback;

        public DisplayCallbackWrapper(@NonNull DisplayCallback<Uri> callback) {
            this.mCallback = callback;
        }

        @Override
        public void onDisplayed(@NonNull Context context, @NonNull Data data, @NonNull Bitmap image, @NonNull ImageView view) {
            this.mCallback.onDisplayed(context, data.getUri(), image, view);
        }
    }

    private static final class ErrorCallbackWrapper
    implements ErrorCallback<Data> {
        private final ErrorCallback<Uri> mCallback;

        public ErrorCallbackWrapper(@NonNull ErrorCallback<Uri> callback) {
            this.mCallback = callback;
        }

        @Override
        public void onError(@NonNull Context context, @NonNull Data data, @NonNull Throwable error) {
            this.mCallback.onError(context, data.getUri(), error);
        }
    }

    private static final class LoadCallbackWrapper
    implements LoadCallback<Data> {
        private final LoadCallback<Uri> mCallback;

        public LoadCallbackWrapper(@NonNull LoadCallback<Uri> callback) {
            this.mCallback = callback;
        }

        @Override
        public void onLoaded(@NonNull Context context, @NonNull Data data, @NonNull Bitmap image) {
            this.mCallback.onLoaded(context, data.getUri(), image);
        }
    }

    private static final class ErrorDrawableWrapper
    implements ErrorDrawableProvider<Data> {
        private final Drawable mDrawable;

        public ErrorDrawableWrapper(@NonNull Drawable drawable) {
            this.mDrawable = drawable;
        }

        @Override
        @NonNull
        public Drawable getErrorDrawable(@NonNull Context context, @NonNull Data data) {
            return this.mDrawable;
        }
    }

    private static final class PlaceholderWrapper
    implements PlaceholderProvider<Data> {
        private final Drawable mDrawable;

        public PlaceholderWrapper(@NonNull Drawable drawable) {
            this.mDrawable = drawable;
        }

        @Override
        @NonNull
        public Drawable getPlaceholder(@NonNull Context context, @NonNull Data data) {
            return this.mDrawable;
        }
    }

    private static final class BitmapTransformationWrapper
    implements BitmapTransformation<Data> {
        private final List<BitmapTransformation<Uri>> mTransformations;
        private final String mKey;

        public BitmapTransformationWrapper(@NonNull List<BitmapTransformation<Uri>> transformations) {
            this.mTransformations = transformations;
            StringBuilder sb = new StringBuilder();
            for (BitmapTransformation<Uri> t : transformations) {
                sb.append(t.getKey());
            }
            this.mKey = sb.toString();
        }

        @Override
        @NonNull
        public Bitmap transform(@NonNull Context context, @NonNull Data data, @NonNull Bitmap bitmap) throws Throwable {
            Uri dataUri = data.getUri();
            boolean first = true;
            for (BitmapTransformation<Uri> transformation : this.mTransformations) {
                Bitmap processed = transformation.transform(context, dataUri, bitmap);
                if (bitmap != processed) {
                    if (!first && !bitmap.isRecycled()) {
                        bitmap.recycle();
                    }
                    first = false;
                }
                bitmap = processed;
            }
            return bitmap;
        }

        @Override
        @NonNull
        public String getKey() {
            return this.mKey;
        }
    }

    private static final class RequestBitmapLoader
    implements BitmapLoader<Data> {
        private RequestBitmapLoader() {
        }

        @Override
        @Nullable
        public Bitmap load(@NonNull Context context, @NonNull Data data) throws Throwable {
            return data.load(context);
        }
    }

    private static final class RequestDataDescriptor
    implements DataDescriptor<Data> {
        private final Data mData;
        private final String mKey;

        public RequestDataDescriptor(@NonNull Data data) {
            this.mData = data;
            String key = DataUtils.generateSHA256(data.getUri().toString());
            if (data.isSampled()) {
                key = key + "_sampled" + data.getRequiredWidth() + "x" + data.getRequiredHeight();
            }
            this.mKey = key;
        }

        @Override
        @NonNull
        public Data getData() {
            return this.mData;
        }

        @Override
        @NonNull
        public String getKey() {
            return this.mKey;
        }
    }

    private static final class Data {
        private final Uri mUri;
        private final int mRequiredWidth;
        private final int mRequiredHeight;

        public Data(@NonNull Uri uri, int requiredWidth, int requiredHeight) {
            this.mUri = uri;
            this.mRequiredWidth = requiredWidth;
            this.mRequiredHeight = requiredHeight;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public Bitmap load(@NonNull Context context) throws Throwable {
            InputStream inputStream;
            block4: {
                Bitmap bitmap;
                if (this.isSampled()) {
                    return DataUtils.loadSampledBitmapFromUri(context, this.mUri, this.mRequiredWidth, this.mRequiredHeight);
                }
                inputStream = null;
                try {
                    inputStream = InternalUtils.getDataStreamFromUri(context, this.mUri);
                    if (inputStream != null) break block4;
                    bitmap = null;
                }
                catch (Throwable throwable) {
                    InternalUtils.close(inputStream);
                    throw throwable;
                }
                InternalUtils.close(inputStream);
                return bitmap;
            }
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            InternalUtils.close(inputStream);
            return bitmap;
        }

        public boolean isSampled() {
            return this.mRequiredWidth > 0 && this.mRequiredHeight > 0;
        }

        public int getRequiredWidth() {
            return this.mRequiredWidth;
        }

        public int getRequiredHeight() {
            return this.mRequiredHeight;
        }

        @NonNull
        public Uri getUri() {
            return this.mUri;
        }
    }

    private static final class ClearMemoryCacheCallbacks
    implements ComponentCallbacks2 {
        private ClearMemoryCacheCallbacks() {
        }

        public void onTrimMemory(int level) {
            ImageLoader loader;
            if (level >= 40 && (loader = sLoader) != null) {
                loader.clearMemoryCache();
            }
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
            ImageLoader loader = sLoader;
            if (loader != null) {
                loader.clearMemoryCache();
            }
        }
    }

    private static final class LoadAction
    implements Runnable {
        private final ImageLoader<Data> mLoader;
        private final DataDescriptor<Data> mDescriptor;
        private final ImageView mView;
        private final PlaceholderProvider<Data> mPlaceholder;
        private final ErrorDrawableProvider<Data> mErrorDrawable;
        private final BitmapTransformation<Data> mTransformation;
        private final LoadCallback<Data> mLoadCallback;
        private final DisplayCallback<Data> mDisplayCallback;
        private final ErrorCallback<Data> mErrorCallback;
        private final boolean mFadeEnabled;
        private final long mFadeDuration;
        private final float mCornerRadius;

        public LoadAction(@NonNull ImageLoader<Data> loader, @NonNull DataDescriptor<Data> descriptor, @NonNull ImageView view, @Nullable PlaceholderProvider<Data> placeholder, @Nullable ErrorDrawableProvider<Data> errorDrawable, @Nullable BitmapTransformation<Data> transformation, @Nullable LoadCallback<Data> loadCallback, @Nullable DisplayCallback<Data> displayCallback, @Nullable ErrorCallback<Data> errorCallback, boolean fadeEnabled, long fadeDuration, float cornerRadius) {
            this.mLoader = loader;
            this.mDescriptor = descriptor;
            this.mView = view;
            this.mPlaceholder = placeholder;
            this.mErrorDrawable = errorDrawable;
            this.mTransformation = transformation;
            this.mLoadCallback = loadCallback;
            this.mDisplayCallback = displayCallback;
            this.mErrorCallback = errorCallback;
            this.mFadeEnabled = fadeEnabled;
            this.mFadeDuration = fadeDuration;
            this.mCornerRadius = cornerRadius;
        }

        @Override
        @MainThread
        public void run() {
            this.mLoader.load(this.mDescriptor, this.mView, this.mPlaceholder, this.mErrorDrawable, this.mTransformation, this.mLoadCallback, this.mErrorCallback, this.mDisplayCallback, this.mFadeEnabled, this.mFadeDuration, this.mCornerRadius);
        }
    }
}

