/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.annotation.SuppressLint;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.AnyThread;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.widget.ImageView;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.BitmapTransformation;
import com.budiyev.android.imageloader.DataDescriptor;
import com.budiyev.android.imageloader.DataUtils;
import com.budiyev.android.imageloader.DisplayCallback;
import com.budiyev.android.imageloader.ErrorCallback;
import com.budiyev.android.imageloader.ErrorDrawableProvider;
import com.budiyev.android.imageloader.ImageLoader;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.LoadCallback;
import com.budiyev.android.imageloader.PlaceholderProvider;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class LoadImageRequest {
    private static final Lock LOADER_LOCK = new ReentrantLock();
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile ImageLoader<RequestImpl> sLoader;
    private final Context mContext;
    private Uri mSource;
    private Drawable mPlaceholder;
    private Drawable mErrorDrawable;
    private LoadCallback<Uri> mLoadCallback;
    private DisplayCallback<Uri> mDisplayCallback;
    private ErrorCallback<Uri> mErrorCallback;
    private ImageView mView;
    private List<BitmapTransformation<Uri>> mTransformations;
    private boolean mFadeEnabled = true;
    private long mFadeDuration = 200L;

    LoadImageRequest(@NonNull Context context) {
        this.mContext = context.getApplicationContext();
    }

    @NonNull
    public LoadImageRequest from(@Nullable Uri uri) {
        this.mSource = uri;
        return this;
    }

    @NonNull
    public LoadImageRequest from(@NonNull String uri) {
        this.mSource = Uri.parse((String)uri);
        return this;
    }

    @NonNull
    public LoadImageRequest from(@NonNull File file) {
        this.mSource = Uri.fromFile((File)file);
        return this;
    }

    @NonNull
    public LoadImageRequest placeholder(@Nullable Drawable placeholder) {
        this.mPlaceholder = placeholder;
        return this;
    }

    @NonNull
    public LoadImageRequest errorDrawable(@Nullable Drawable errorDrawable) {
        this.mErrorDrawable = errorDrawable;
        return this;
    }

    @NonNull
    public LoadImageRequest transform(@NonNull BitmapTransformation<Uri> transformation) {
        List<BitmapTransformation<Uri>> transformations = this.mTransformations;
        if (transformations == null) {
            this.mTransformations = transformations = new ArrayList<BitmapTransformation<Uri>>();
        }
        transformations.add(transformation);
        return this;
    }

    @NonNull
    public LoadImageRequest fade() {
        this.mFadeEnabled = true;
        return this;
    }

    @NonNull
    public LoadImageRequest noFade() {
        this.mFadeEnabled = true;
        return this;
    }

    @NonNull
    public LoadImageRequest fade(boolean enabled, long duration) {
        this.mFadeEnabled = enabled;
        this.mFadeDuration = duration;
        return this;
    }

    @NonNull
    public LoadImageRequest onLoaded(@Nullable LoadCallback<Uri> callback) {
        this.mLoadCallback = callback;
        return this;
    }

    @NonNull
    public LoadImageRequest onError(@Nullable ErrorCallback<Uri> callback) {
        this.mErrorCallback = callback;
        return this;
    }

    @NonNull
    public LoadImageRequest onDisplayed(@Nullable DisplayCallback<Uri> callback) {
        this.mDisplayCallback = callback;
        return this;
    }

    @NonNull
    public LoadImageRequest into(@Nullable ImageView view) {
        this.mView = view;
        return this;
    }

    @AnyThread
    public void load() {
        Uri source = this.mSource;
        if (source == null) {
            return;
        }
        ImageView view = this.mView;
        ImageLoader<RequestImpl> loader = LoadImageRequest.getLoader(this.mContext);
        DataDescriptorImpl descriptor = new DataDescriptorImpl(new RequestImpl(source, this.mPlaceholder, this.mErrorDrawable, this.mLoadCallback, this.mDisplayCallback, this.mErrorCallback));
        if (view == null) {
            loader.load(descriptor);
        } else {
            BitmapTransformationImpl transformation = this.mTransformations != null ? new BitmapTransformationImpl(this.mTransformations, source) : null;
            loader.runOnMainThread(new LoadAction(loader, descriptor, transformation, view, this.mFadeEnabled, this.mFadeDuration));
        }
    }

    @NonNull
    private static ImageLoader<RequestImpl> getLoader(@NonNull Context context) {
        ImageLoader<RequestImpl> loader = sLoader;
        if (loader == null) {
            LOADER_LOCK.lock();
            try {
                loader = sLoader;
                if (loader == null) {
                    loader = ImageLoader.builder(context).custom(new BitmapLoaderImpl()).memoryCache().storageCache().placeholder(new PlaceholderProviderImpl()).errorDrawable(new ErrorDrawableProviderImpl()).onLoaded(new LoadCallbackImpl()).onError(new ErrorCallbackImpl()).onDisplayed(new DisplayCallbackImpl()).build();
                    context.getApplicationContext().registerComponentCallbacks((ComponentCallbacks)new ComponentCallbacksImpl());
                    sLoader = loader;
                }
            }
            finally {
                LOADER_LOCK.unlock();
            }
        }
        return loader;
    }

    private static final class DisplayCallbackImpl
    implements DisplayCallback<RequestImpl> {
        private DisplayCallbackImpl() {
        }

        @Override
        public void onDisplayed(@NonNull Context context, @NonNull RequestImpl data, @NonNull Bitmap image, @NonNull ImageView view) {
            data.onDisplayed(context, image, view);
        }
    }

    private static final class ErrorCallbackImpl
    implements ErrorCallback<RequestImpl> {
        private ErrorCallbackImpl() {
        }

        @Override
        public void onError(@NonNull Context context, @NonNull RequestImpl data, @NonNull Throwable error) {
            data.onError(context, error);
        }
    }

    private static final class LoadCallbackImpl
    implements LoadCallback<RequestImpl> {
        private LoadCallbackImpl() {
        }

        @Override
        public void onLoaded(@NonNull Context context, @NonNull RequestImpl data, @NonNull Bitmap image) {
            data.onLoaded(context, image);
        }
    }

    private static final class BitmapTransformationImpl
    implements BitmapTransformation<RequestImpl> {
        private final List<BitmapTransformation<Uri>> mTransformations;
        private final String mKey;

        private BitmapTransformationImpl(@NonNull List<BitmapTransformation<Uri>> transformations, @NonNull Uri data) {
            this.mTransformations = transformations;
            StringBuilder sb = new StringBuilder();
            for (BitmapTransformation<Uri> transformation : transformations) {
                sb.append(transformation.getKey(data));
            }
            this.mKey = sb.toString();
        }

        @Override
        @NonNull
        public Bitmap transform(@NonNull Context context, @NonNull RequestImpl data, @NonNull Bitmap bitmap) throws Throwable {
            List<BitmapTransformation<Uri>> transformations = this.mTransformations;
            if (transformations == null) {
                return bitmap;
            }
            Uri source = data.getSource();
            boolean first = true;
            for (BitmapTransformation<Uri> transformation : transformations) {
                Bitmap processed = transformation.transform(context, source, bitmap);
                if (bitmap != processed) {
                    if (!first && !bitmap.isRecycled()) {
                        bitmap.recycle();
                    }
                    first = false;
                }
                bitmap = processed;
            }
            return bitmap;
        }

        @Override
        @NonNull
        public String getKey(@NonNull RequestImpl data) {
            return this.mKey;
        }
    }

    private static final class ErrorDrawableProviderImpl
    implements ErrorDrawableProvider<RequestImpl> {
        private ErrorDrawableProviderImpl() {
        }

        @Override
        @Nullable
        public Drawable getErrorDrawable(@NonNull Context context, @NonNull RequestImpl data) {
            return data.getErrorDrawable();
        }
    }

    private static final class PlaceholderProviderImpl
    implements PlaceholderProvider<RequestImpl> {
        private PlaceholderProviderImpl() {
        }

        @Override
        @NonNull
        public Drawable getPlaceholder(@NonNull Context context, @NonNull RequestImpl data) {
            return data.getPlaceholder();
        }
    }

    private static final class BitmapLoaderImpl
    implements BitmapLoader<RequestImpl> {
        private BitmapLoaderImpl() {
        }

        @Override
        @Nullable
        public Bitmap load(@NonNull Context context, @NonNull RequestImpl data) throws Throwable {
            return data.load(context);
        }
    }

    private static final class DataDescriptorImpl
    implements DataDescriptor<RequestImpl> {
        private final RequestImpl mRequest;

        public DataDescriptorImpl(@NonNull RequestImpl request) {
            this.mRequest = request;
        }

        @Override
        @NonNull
        public RequestImpl getData() {
            return this.mRequest;
        }

        @Override
        @NonNull
        public String getKey() {
            return this.mRequest.getKey();
        }
    }

    private static final class RequestImpl {
        private final Uri mSource;
        private final String mKey;
        private final Drawable mPlaceholder;
        private final Drawable mErrorDrawable;
        private final LoadCallback<Uri> mLoadCallback;
        private final DisplayCallback<Uri> mDisplayCallback;
        private final ErrorCallback<Uri> mErrorCallback;

        private RequestImpl(@NonNull Uri source, @Nullable Drawable placeholder, @Nullable Drawable errorDrawable, @Nullable LoadCallback<Uri> loadCallback, @Nullable DisplayCallback<Uri> displayCallback, @Nullable ErrorCallback<Uri> errorCallback) {
            this.mSource = source;
            this.mKey = DataUtils.generateSHA256(source.toString());
            this.mPlaceholder = placeholder;
            this.mErrorDrawable = errorDrawable;
            this.mLoadCallback = loadCallback;
            this.mDisplayCallback = displayCallback;
            this.mErrorCallback = errorCallback;
        }

        @NonNull
        public Uri getSource() {
            return this.mSource;
        }

        @NonNull
        private String getKey() {
            return this.mKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private Bitmap load(@NonNull Context context) throws Throwable {
            InputStream inputStream;
            block3: {
                Bitmap bitmap;
                inputStream = null;
                try {
                    inputStream = InternalUtils.getDataStreamFromUri(context, this.mSource);
                    if (inputStream != null) break block3;
                    bitmap = null;
                }
                catch (Throwable throwable) {
                    InternalUtils.close(inputStream);
                    throw throwable;
                }
                InternalUtils.close(inputStream);
                return bitmap;
            }
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            InternalUtils.close(inputStream);
            return bitmap;
        }

        @NonNull
        private Drawable getPlaceholder() {
            Drawable placeholder = this.mPlaceholder;
            if (placeholder != null) {
                return placeholder;
            }
            return new ColorDrawable(0);
        }

        @Nullable
        private Drawable getErrorDrawable() {
            return this.mErrorDrawable;
        }

        private void onLoaded(@NonNull Context context, @NonNull Bitmap image) {
            LoadCallback<Uri> loadCallback = this.mLoadCallback;
            if (loadCallback != null) {
                loadCallback.onLoaded(context, this.mSource, image);
            }
        }

        private void onError(@NonNull Context context, @NonNull Throwable error) {
            ErrorCallback<Uri> errorCallback = this.mErrorCallback;
            if (errorCallback != null) {
                errorCallback.onError(context, this.mSource, error);
            }
        }

        private void onDisplayed(@NonNull Context context, @NonNull Bitmap image, @NonNull ImageView view) {
            DisplayCallback<Uri> displayCallback = this.mDisplayCallback;
            if (displayCallback != null) {
                displayCallback.onDisplayed(context, this.mSource, image, view);
            }
        }
    }

    private static final class ComponentCallbacksImpl
    implements ComponentCallbacks2 {
        private ComponentCallbacksImpl() {
        }

        public void onTrimMemory(int level) {
            ImageLoader loader;
            if (level >= 40 && (loader = sLoader) != null) {
                loader.clearMemoryCache();
            }
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
            ImageLoader loader = sLoader;
            if (loader != null) {
                loader.clearMemoryCache();
            }
        }
    }

    private static final class LoadAction
    implements Runnable {
        private final ImageLoader<RequestImpl> mLoader;
        private final DataDescriptor<RequestImpl> mDescriptor;
        private final BitmapTransformation<RequestImpl> mTransformation;
        private final ImageView mView;
        private final boolean mFadeEnabled;
        private final long mFadeDuration;

        private LoadAction(@NonNull ImageLoader<RequestImpl> loader, @NonNull DataDescriptor<RequestImpl> descriptor, @Nullable BitmapTransformation<RequestImpl> transformation, @NonNull ImageView view, boolean fadeEnabled, long fadeDuration) {
            this.mLoader = loader;
            this.mDescriptor = descriptor;
            this.mTransformation = transformation;
            this.mView = view;
            this.mFadeEnabled = fadeEnabled;
            this.mFadeDuration = fadeDuration;
        }

        @Override
        @MainThread
        public void run() {
            this.mLoader.load(this.mDescriptor, this.mView, this.mTransformation, this.mLoader.getLoadCallback(), this.mLoader.getErrorCallback(), this.mLoader.getDisplayCallback(), this.mFadeEnabled, this.mFadeDuration);
        }
    }
}

