/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.support.annotation.AnyThread;
import android.support.annotation.DrawableRes;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.widget.ImageView;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.BitmapTransformation;
import com.budiyev.android.imageloader.ByteArrayBitmapLoader;
import com.budiyev.android.imageloader.CompressMode;
import com.budiyev.android.imageloader.DataDescriptor;
import com.budiyev.android.imageloader.DisplayCallback;
import com.budiyev.android.imageloader.DisplayImageAction;
import com.budiyev.android.imageloader.ErrorCallback;
import com.budiyev.android.imageloader.ErrorDrawableProvider;
import com.budiyev.android.imageloader.FileBitmapLoader;
import com.budiyev.android.imageloader.FileDescriptorBitmapLoader;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.ImageLoaderExecutor;
import com.budiyev.android.imageloader.ImagePlaceholderProvider;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.LoadCallback;
import com.budiyev.android.imageloader.LoadImageAction;
import com.budiyev.android.imageloader.LoadImageRequest;
import com.budiyev.android.imageloader.MemoryImageCache;
import com.budiyev.android.imageloader.PauseLock;
import com.budiyev.android.imageloader.PlaceholderDrawable;
import com.budiyev.android.imageloader.PlaceholderProvider;
import com.budiyev.android.imageloader.ResourceBitmapLoader;
import com.budiyev.android.imageloader.StorageImageCache;
import com.budiyev.android.imageloader.UriBitmapLoader;
import java.io.File;
import java.io.FileDescriptor;
import java.util.concurrent.ExecutorService;

public final class ImageLoader<T> {
    private final PauseLock mPauseLock = new PauseLock();
    private final Context mContext;
    private final Handler mMainThreadHandler;
    private final BitmapLoader<T> mBitmapLoader;
    private final BitmapTransformation<T> mBitmapTransformation;
    private final ImageCache mMemoryCache;
    private final ImageCache mStorageCache;
    private final PlaceholderProvider<T> mPlaceholderProvider;
    private final ErrorDrawableProvider<T> mErrorDrawableProvider;
    private final ExecutorService mExecutor;
    private final LoadCallback<T> mLoadCallback;
    private final DisplayCallback<T> mDisplayCallback;
    private final ErrorCallback<T> mErrorCallback;
    private final boolean mFadeEnabled;
    private final long mFadeDuration;

    private ImageLoader(@NonNull Context context, @NonNull BitmapLoader<T> bitmapLoader, @Nullable BitmapTransformation<T> bitmapTransformation, @Nullable ImageCache memoryCache, @Nullable ImageCache storageCache, @Nullable PlaceholderProvider<T> placeholderProvider, @Nullable ErrorDrawableProvider<T> errorDrawableProvider, @Nullable ExecutorService executor, @Nullable LoadCallback<T> loadCallback, @Nullable DisplayCallback<T> displayCallback, @Nullable ErrorCallback<T> errorCallback, boolean fadeEnabled, long fadeDuration) {
        this.mContext = context;
        this.mMainThreadHandler = new Handler(context.getMainLooper());
        this.mBitmapLoader = bitmapLoader;
        this.mBitmapTransformation = bitmapTransformation;
        this.mMemoryCache = memoryCache;
        this.mStorageCache = storageCache;
        this.mErrorDrawableProvider = errorDrawableProvider;
        this.mLoadCallback = loadCallback;
        this.mDisplayCallback = displayCallback;
        this.mErrorCallback = errorCallback;
        this.mPlaceholderProvider = placeholderProvider;
        this.mExecutor = executor != null ? executor : new ImageLoaderExecutor(InternalUtils.getPoolSize());
        if (this.mStorageCache instanceof StorageImageCache) {
            ((StorageImageCache)this.mStorageCache).setExecutor(this.mExecutor);
        }
        this.mFadeEnabled = fadeEnabled;
        this.mFadeDuration = fadeDuration;
    }

    @MainThread
    public void load(@NonNull DataDescriptor<T> descriptor, @NonNull ImageView view) {
        this.load(descriptor, view, this.mBitmapTransformation, this.mLoadCallback, this.mErrorCallback, this.mDisplayCallback, this.mFadeEnabled, this.mFadeDuration);
    }

    @MainThread
    public void load(@NonNull DataDescriptor<T> descriptor, @NonNull ImageView view, @Nullable BitmapTransformation<T> transformation) {
        this.load(descriptor, view, transformation, this.mLoadCallback, this.mErrorCallback, this.mDisplayCallback, this.mFadeEnabled, this.mFadeDuration);
    }

    @MainThread
    public void load(@NonNull DataDescriptor<T> descriptor, @NonNull ImageView view, @Nullable BitmapTransformation<T> transformation, @Nullable LoadCallback<T> loadCallback, @Nullable ErrorCallback<T> errorCallback, @Nullable DisplayCallback<T> displayCallback) {
        this.load(descriptor, view, transformation, loadCallback, errorCallback, displayCallback, this.mFadeEnabled, this.mFadeDuration);
    }

    @MainThread
    public void load(@NonNull DataDescriptor<T> descriptor, @NonNull ImageView view, @Nullable BitmapTransformation<T> transformation, @Nullable LoadCallback<T> loadCallback, @Nullable ErrorCallback<T> errorCallback, @Nullable DisplayCallback<T> displayCallback, boolean fadeEnabled, long fadeDuration) {
        PlaceholderProvider<T> placeholderProvider;
        Bitmap image = null;
        String key = descriptor.getKey();
        ImageCache memoryCache = this.mMemoryCache;
        T data = descriptor.getData();
        if (memoryCache != null) {
            image = transformation != null ? memoryCache.get(key + transformation.getKey(data)) : memoryCache.get(key);
        }
        Context context = this.mContext;
        if (image != null) {
            if (loadCallback != null) {
                loadCallback.onLoaded(context, data, image);
            }
            view.setImageBitmap(image);
            if (displayCallback != null) {
                displayCallback.onDisplayed(context, data, image, view);
            }
            return;
        }
        DisplayImageAction<?> currentAction = InternalUtils.getDisplayImageAction(view);
        if (currentAction != null) {
            if (currentAction.hasSameDescriptor(key)) {
                return;
            }
            currentAction.cancel();
        }
        Object placeholder = (placeholderProvider = this.mPlaceholderProvider) != null ? placeholderProvider.getPlaceholder(context, data) : new ColorDrawable(0);
        ErrorDrawableProvider<T> errorDrawableProvider = this.mErrorDrawableProvider;
        Drawable errorDrawable = errorDrawableProvider != null ? errorDrawableProvider.getErrorDrawable(context, data) : null;
        DisplayImageAction<T> action = new DisplayImageAction<T>(context, descriptor, this.mBitmapLoader, this.mPauseLock, this.mStorageCache, loadCallback, errorCallback, this.mMainThreadHandler, transformation, memoryCache, displayCallback, view, (Drawable)placeholder, errorDrawable, fadeEnabled, fadeDuration);
        view.setImageDrawable((Drawable)new PlaceholderDrawable((Drawable)placeholder, action));
        action.execute(this.mExecutor);
    }

    @AnyThread
    public void load(@NonNull DataDescriptor<T> descriptor) {
        this.load(descriptor, this.mLoadCallback, this.mErrorCallback);
    }

    @AnyThread
    public void load(@NonNull DataDescriptor<T> descriptor, @Nullable LoadCallback<T> loadCallback, @Nullable ErrorCallback<T> errorCallback) {
        new LoadImageAction<T>(this.mContext, descriptor, this.mBitmapLoader, this.mPauseLock, this.mMemoryCache, this.mStorageCache, loadCallback, errorCallback).execute(this.mExecutor);
    }

    public void invalidate(@NonNull DataDescriptor<T> descriptor) {
        ImageCache storageCache;
        String key = descriptor.getKey();
        ImageCache memoryCache = this.mMemoryCache;
        if (memoryCache != null) {
            memoryCache.remove(key);
        }
        if ((storageCache = this.mStorageCache) != null) {
            storageCache.remove(key);
        }
    }

    public boolean isLoadingPaused() {
        return this.mPauseLock.isPaused();
    }

    public void setPauseLoading(boolean paused) {
        this.mPauseLock.setPaused(paused);
    }

    @Nullable
    public BitmapTransformation<T> getBitmapTransformation() {
        return this.mBitmapTransformation;
    }

    @Nullable
    public PlaceholderProvider<T> getPlaceholderProvider() {
        return this.mPlaceholderProvider;
    }

    @Nullable
    public ErrorDrawableProvider<T> getErrorDrawableProvider() {
        return this.mErrorDrawableProvider;
    }

    @Nullable
    public LoadCallback<T> getLoadCallback() {
        return this.mLoadCallback;
    }

    @Nullable
    public DisplayCallback<T> getDisplayCallback() {
        return this.mDisplayCallback;
    }

    @Nullable
    public ErrorCallback<T> getErrorCallback() {
        return this.mErrorCallback;
    }

    public boolean isFadeEnabled() {
        return this.mFadeEnabled;
    }

    public long getFadeDuration() {
        return this.mFadeDuration;
    }

    public void clearMemoryCache() {
        ImageCache memoryCache = this.mMemoryCache;
        if (memoryCache != null) {
            memoryCache.clear();
        }
    }

    public void clearStorageCache() {
        ImageCache storageCache = this.mStorageCache;
        if (storageCache != null) {
            storageCache.clear();
        }
    }

    public void clearAllCaches() {
        this.clearMemoryCache();
        this.clearStorageCache();
    }

    void runOnMainThread(@NonNull Runnable action) {
        this.mMainThreadHandler.post(action);
    }

    @NonNull
    @AnyThread
    public static LoadImageRequest with(@NonNull Context context) {
        return new LoadImageRequest(context);
    }

    @NonNull
    public static BuilderSelector builder(@NonNull Context context) {
        return new BuilderSelector(context);
    }

    public static final class Builder<T> {
        private final Context mContext;
        private final BitmapLoader<T> mBitmapLoader;
        private BitmapTransformation<T> mBitmapTransformation;
        private ImageCache mMemoryCache;
        private ImageCache mStorageCache;
        private PlaceholderProvider<T> mPlaceholderProvider;
        private ErrorDrawableProvider<T> mErrorDrawableProvider;
        private ExecutorService mExecutor;
        private LoadCallback<T> mLoadCallback;
        private DisplayCallback<T> mDisplayCallback;
        private ErrorCallback<T> mErrorCallback;
        private boolean mFadeEnabled = true;
        private long mFadeDuration = 200L;

        private Builder(@NonNull Context context, @NonNull BitmapLoader<T> bitmapLoader) {
            this.mContext = context;
            this.mBitmapLoader = bitmapLoader;
        }

        @NonNull
        public Builder<T> memoryCache() {
            this.mMemoryCache = new MemoryImageCache();
            return this;
        }

        @NonNull
        public Builder<T> memoryCache(int maxSize) {
            this.mMemoryCache = new MemoryImageCache(maxSize);
            return this;
        }

        @NonNull
        public Builder<T> memoryCache(@Nullable ImageCache memoryCache) {
            this.mMemoryCache = memoryCache;
            return this;
        }

        @NonNull
        public Builder<T> storageCache() {
            this.mStorageCache = new StorageImageCache(this.mContext);
            return this;
        }

        @NonNull
        public Builder<T> storageCache(long maxSize) {
            this.mStorageCache = new StorageImageCache(this.mContext, maxSize);
            return this;
        }

        @NonNull
        public Builder<T> storageCache(@NonNull CompressMode compressMode, long maxSize) {
            this.mStorageCache = new StorageImageCache(this.mContext, compressMode, maxSize);
            return this;
        }

        @NonNull
        public Builder<T> storageCache(@NonNull File directory) {
            this.mStorageCache = new StorageImageCache(directory);
            return this;
        }

        @NonNull
        public Builder<T> storageCache(@NonNull File directory, long maxSize) {
            this.mStorageCache = new StorageImageCache(directory, maxSize);
            return this;
        }

        @NonNull
        public Builder<T> storageCache(@NonNull File directory, @NonNull CompressMode compressMode, long maxSize) {
            this.mStorageCache = new StorageImageCache(directory, compressMode, maxSize);
            return this;
        }

        @NonNull
        public Builder<T> storageCache(@Nullable ImageCache storageCache) {
            this.mStorageCache = storageCache;
            return this;
        }

        @NonNull
        public Builder<T> placeholder(@NonNull Bitmap image) {
            this.mPlaceholderProvider = new ImagePlaceholderProvider(this.mContext.getResources(), image);
            return this;
        }

        @NonNull
        public Builder<T> placeholder(@DrawableRes int imageRes) {
            Resources resources = this.mContext.getResources();
            Bitmap image = BitmapFactory.decodeResource((Resources)resources, (int)imageRes);
            if (image != null) {
                this.mPlaceholderProvider = new ImagePlaceholderProvider(resources, image);
            }
            return this;
        }

        @NonNull
        public Builder<T> placeholder(@Nullable PlaceholderProvider<T> provider) {
            this.mPlaceholderProvider = provider;
            return this;
        }

        @NonNull
        public Builder<T> errorDrawable(@Nullable ErrorDrawableProvider<T> provider) {
            this.mErrorDrawableProvider = provider;
            return this;
        }

        @NonNull
        public Builder<T> transform(@Nullable BitmapTransformation<T> processor) {
            this.mBitmapTransformation = processor;
            return this;
        }

        @NonNull
        public Builder<T> fade(boolean enabled) {
            this.mFadeEnabled = enabled;
            return this;
        }

        @NonNull
        public Builder<T> fade(boolean enabled, long duration) {
            this.mFadeEnabled = enabled;
            this.mFadeDuration = duration;
            return this;
        }

        @NonNull
        public Builder<T> executor(@Nullable ExecutorService executor) {
            this.mExecutor = executor;
            return this;
        }

        @NonNull
        public Builder<T> onLoaded(@Nullable LoadCallback<T> callback) {
            this.mLoadCallback = callback;
            return this;
        }

        @NonNull
        public Builder<T> onError(@Nullable ErrorCallback<T> callback) {
            this.mErrorCallback = callback;
            return this;
        }

        @NonNull
        public Builder<T> onDisplayed(@Nullable DisplayCallback<T> callback) {
            this.mDisplayCallback = callback;
            return this;
        }

        @NonNull
        public ImageLoader<T> build() {
            return new ImageLoader(this.mContext, this.mBitmapLoader, this.mBitmapTransformation, this.mMemoryCache, this.mStorageCache, this.mPlaceholderProvider, this.mErrorDrawableProvider, this.mExecutor, this.mLoadCallback, this.mDisplayCallback, this.mErrorCallback, this.mFadeEnabled, this.mFadeDuration);
        }
    }

    public static final class BuilderSelector {
        private final Context mContext;

        private BuilderSelector(@NonNull Context context) {
            this.mContext = context.getApplicationContext();
        }

        @NonNull
        public Builder<Uri> uri() {
            return new Builder<Uri>(this.mContext, new UriBitmapLoader());
        }

        @NonNull
        public Builder<File> file() {
            return new Builder<File>(this.mContext, new FileBitmapLoader());
        }

        @NonNull
        public Builder<FileDescriptor> fileDescriptor() {
            return new Builder<FileDescriptor>(this.mContext, new FileDescriptorBitmapLoader());
        }

        @NonNull
        public Builder<Integer> resource() {
            return new Builder<Integer>(this.mContext, new ResourceBitmapLoader());
        }

        @NonNull
        public Builder<byte[]> byteArray() {
            return new Builder<byte[]>(this.mContext, new ByteArrayBitmapLoader());
        }

        @NonNull
        public <T> Builder<T> custom(@NonNull BitmapLoader<T> bitmapLoader) {
            return new Builder(this.mContext, bitmapLoader);
        }
    }
}

