/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.support.annotation.NonNull;
import com.budiyev.android.imageloader.DataDescriptor;
import com.budiyev.android.imageloader.DataUtils;

final class StringDataDescriptor<T>
implements DataDescriptor<T> {
    private final T mData;
    private final String mKey;

    public StringDataDescriptor(@NonNull T data) {
        this.mData = data;
        this.mKey = DataUtils.generateSHA256(data.toString());
    }

    @Override
    @NonNull
    public T getData() {
        return this.mData;
    }

    @Override
    @NonNull
    public String getKey() {
        return this.mKey;
    }

    public int hashCode() {
        return this.mKey.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof StringDataDescriptor && this.mKey.equals(((StringDataDescriptor)obj).mKey);
    }

    @NonNull
    public String toString() {
        return "DataDescriptor [key: " + this.mKey + ", data: " + this.mData + "]";
    }
}

