/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.AnyThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.DataDescriptor;
import com.budiyev.android.imageloader.ErrorCallback;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.ImageNotLoadedException;
import com.budiyev.android.imageloader.LoadCallback;
import com.budiyev.android.imageloader.PauseLock;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

abstract class BaseLoadImageAction<T> {
    private final Context mContext;
    private final DataDescriptor<T> mDescriptor;
    private final BitmapLoader<T> mBitmapLoader;
    private final PauseLock mPauseLock;
    private final ImageCache mStorageCache;
    private final LoadCallback<T> mLoadCallback;
    private final ErrorCallback<T> mErrorCallback;
    private volatile Future<?> mFuture;
    private volatile boolean mCancelled;
    private volatile boolean mCalled;

    protected BaseLoadImageAction(@NonNull Context context, @NonNull DataDescriptor<T> descriptor, @NonNull BitmapLoader<T> bitmapLoader, @NonNull PauseLock pauseLock, @Nullable ImageCache storageCache, @Nullable LoadCallback<T> loadCallback, @Nullable ErrorCallback<T> errorCallback) {
        this.mContext = context;
        this.mDescriptor = descriptor;
        this.mBitmapLoader = bitmapLoader;
        this.mPauseLock = pauseLock;
        this.mStorageCache = storageCache;
        this.mLoadCallback = loadCallback;
        this.mErrorCallback = errorCallback;
    }

    @WorkerThread
    protected abstract void onImageLoaded(@NonNull Bitmap var1);

    @AnyThread
    protected abstract void onCancelled();

    @AnyThread
    public final void execute(@NonNull ExecutorService executor) {
        if (this.mCalled) {
            throw new IllegalStateException("Action can be executed only once");
        }
        this.mCalled = true;
        if (this.mCancelled) {
            return;
        }
        this.mFuture = executor.submit(new LoadImageTask());
    }

    @AnyThread
    public final void cancel() {
        this.mCancelled = true;
        Future<?> future = this.mFuture;
        if (future != null) {
            future.cancel(false);
        }
        this.onCancelled();
    }

    @NonNull
    protected final Context getContext() {
        return this.mContext;
    }

    @NonNull
    protected final DataDescriptor<T> getDescriptor() {
        return this.mDescriptor;
    }

    @NonNull
    protected final BitmapLoader<T> getBitmapLoader() {
        return this.mBitmapLoader;
    }

    @NonNull
    protected final PauseLock getPauseLock() {
        return this.mPauseLock;
    }

    @Nullable
    protected final ImageCache getStorageCache() {
        return this.mStorageCache;
    }

    @Nullable
    protected final LoadCallback<T> getLoadCallback() {
        return this.mLoadCallback;
    }

    @Nullable
    protected final ErrorCallback<T> getErrorCallback() {
        return this.mErrorCallback;
    }

    protected final boolean isCancelled() {
        return this.mCancelled;
    }

    @WorkerThread
    private void loadImage() {
        while (!this.mCancelled && this.mPauseLock.isPaused()) {
            if (!this.mPauseLock.await()) continue;
            return;
        }
        if (this.mCancelled) {
            return;
        }
        Bitmap image = null;
        ImageCache storageCache = this.mStorageCache;
        String key = this.mDescriptor.getKey();
        T data = this.mDescriptor.getData();
        if (storageCache != null) {
            image = storageCache.get(key);
        }
        Context context = this.mContext;
        if (image != null) {
            this.notifyImageLoaded(context, data, image);
            return;
        }
        try {
            image = this.mBitmapLoader.load(context, data);
        }
        catch (Throwable error) {
            ErrorCallback<T> errorCallback = this.mErrorCallback;
            if (errorCallback != null) {
                errorCallback.onError(context, data, error);
            }
            return;
        }
        if (image == null) {
            ErrorCallback<T> errorCallback = this.mErrorCallback;
            if (errorCallback != null) {
                errorCallback.onError(context, data, new ImageNotLoadedException());
            }
            return;
        }
        if (this.mCancelled) {
            return;
        }
        this.notifyImageLoaded(context, data, image);
        if (this.mCancelled) {
            return;
        }
        if (storageCache != null) {
            storageCache.put(key, image);
        }
    }

    private void notifyImageLoaded(@NonNull Context context, @NonNull T data, @NonNull Bitmap image) {
        LoadCallback<T> loadCallback = this.mLoadCallback;
        if (loadCallback != null) {
            loadCallback.onLoaded(context, data, image);
        }
        this.onImageLoaded(image);
    }

    private final class LoadImageTask
    implements Callable<Void> {
        private LoadImageTask() {
        }

        @Override
        public Void call() throws Exception {
            BaseLoadImageAction.this.loadImage();
            BaseLoadImageAction.this.mFuture = null;
            return null;
        }
    }
}

