/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.TypedValue;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.InternalUtils;
import java.io.InputStream;

final class ResourceBitmapLoader
implements BitmapLoader<Integer> {
    ResourceBitmapLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Bitmap load(@NonNull Context context, @NonNull Integer data) throws Throwable {
        Bitmap bitmap;
        Resources resources = context.getResources();
        BitmapFactory.Options options = new BitmapFactory.Options();
        TypedValue typedValue = new TypedValue();
        options.inTargetDensity = resources.getDisplayMetrics().densityDpi;
        if (typedValue.density == 0) {
            options.inDensity = 160;
        } else if (typedValue.density != 65535) {
            options.inDensity = typedValue.density;
        }
        InputStream inputStream = null;
        try {
            inputStream = resources.openRawResource(data.intValue(), typedValue);
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        }
        catch (Throwable throwable) {
            InternalUtils.close(inputStream);
            throw throwable;
        }
        InternalUtils.close(inputStream);
        return bitmap;
    }
}

