/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.widget.ImageView;
import com.budiyev.android.imageloader.BaseLoadImageAction;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.BitmapProcessor;
import com.budiyev.android.imageloader.DataDescriptor;
import com.budiyev.android.imageloader.DisplayCallback;
import com.budiyev.android.imageloader.ErrorCallback;
import com.budiyev.android.imageloader.FadeDrawable;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.LoadCallback;
import com.budiyev.android.imageloader.PauseLock;
import java.lang.ref.WeakReference;

final class DisplayImageAction<T>
extends BaseLoadImageAction<T> {
    private final Handler mMainThreadHandler;
    private final BitmapProcessor<T> mBitmapProcessor;
    private final ImageCache mMemoryCache;
    private final DisplayCallback<T> mDisplayCallback;
    private final WeakReference<ImageView> mView;
    private final Drawable mPlaceholder;
    private final boolean mFadeEnabled;
    private final long mFadeDuration;

    protected DisplayImageAction(@NonNull Context context, @NonNull DataDescriptor<T> descriptor, @NonNull BitmapLoader<T> bitmapLoader, @NonNull PauseLock pauseLock, @Nullable ImageCache storageCache, @Nullable LoadCallback<T> loadCallback, @Nullable ErrorCallback<T> errorCallback, @NonNull Handler mainThreadHandler, @Nullable BitmapProcessor<T> bitmapProcessor, @Nullable ImageCache memoryCache, @Nullable DisplayCallback<T> displayCallback, @NonNull ImageView view, @NonNull Drawable placeholder, boolean fadeEnabled, long fadeDuration) {
        super(context, descriptor, bitmapLoader, pauseLock, storageCache, loadCallback, errorCallback);
        this.mMainThreadHandler = mainThreadHandler;
        this.mBitmapProcessor = bitmapProcessor;
        this.mMemoryCache = memoryCache;
        this.mDisplayCallback = displayCallback;
        this.mView = new WeakReference<ImageView>(view);
        this.mPlaceholder = placeholder;
        this.mFadeEnabled = fadeEnabled;
        this.mFadeDuration = fadeDuration;
    }

    public boolean hasSameDescriptor(@NonNull String descriptorKey) {
        return this.getDescriptor().getKey().equals(descriptorKey);
    }

    @Override
    protected void onImageLoaded(@NonNull Bitmap image) {
        BitmapProcessor bitmapProcessor;
        DataDescriptor descriptor = this.getDescriptor();
        ImageCache memoryImageCache = this.mMemoryCache;
        if (memoryImageCache != null) {
            memoryImageCache.put(descriptor.getKey(), image);
        }
        if ((bitmapProcessor = this.mBitmapProcessor) != null) {
            image = bitmapProcessor.process(this.getContext(), descriptor.getData(), image);
        }
        if (this.isCancelled() || this.mView.get() == null) {
            return;
        }
        this.mMainThreadHandler.post((Runnable)new SetImageAction(image));
    }

    @Override
    protected void onCancelled() {
        this.mView.clear();
    }

    private static final class FadeCallback<T>
    implements FadeDrawable.FadeCallback {
        private final Context mContext;
        private final DisplayCallback<T> mDisplayCallback;
        private final T mData;
        private final Bitmap mImage;
        private final ImageView mView;

        private FadeCallback(@NonNull Context context, @NonNull DisplayCallback<T> displayCallback, @NonNull T data, @NonNull Bitmap image, @NonNull ImageView view) {
            this.mContext = context;
            this.mDisplayCallback = displayCallback;
            this.mData = data;
            this.mImage = image;
            this.mView = view;
        }

        @Override
        public void onDone() {
            this.mDisplayCallback.onDisplayed(this.mContext, this.mData, this.mImage, this.mView);
        }
    }

    private final class SetImageAction
    implements Runnable {
        private final Bitmap mImage;

        public SetImageAction(Bitmap image) {
            this.mImage = image;
        }

        @Override
        @MainThread
        public void run() {
            if (DisplayImageAction.this.isCancelled()) {
                return;
            }
            ImageView view = (ImageView)DisplayImageAction.this.mView.get();
            if (view == null || InternalUtils.getDisplayImageAction(view) != DisplayImageAction.this) {
                return;
            }
            Bitmap image = this.mImage;
            Context context = DisplayImageAction.this.getContext();
            Object data = DisplayImageAction.this.getDescriptor().getData();
            DisplayCallback displayCallback = DisplayImageAction.this.mDisplayCallback;
            if (DisplayImageAction.this.mFadeEnabled && Build.VERSION.SDK_INT >= 19) {
                view.setImageDrawable((Drawable)new FadeDrawable(DisplayImageAction.this.mPlaceholder, (Drawable)new BitmapDrawable(context.getResources(), image), DisplayImageAction.this.mFadeDuration, DisplayImageAction.this.mMainThreadHandler, displayCallback == null ? null : new FadeCallback(context, displayCallback, data, image, view)));
            } else {
                view.setImageBitmap(image);
                if (displayCallback != null) {
                    displayCallback.onDisplayed(context, data, image, view);
                }
            }
        }
    }
}

