/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.support.annotation.NonNull;
import java.io.OutputStream;
import java.util.Arrays;

final class ByteBuffer
extends OutputStream {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private byte[] mArray;
    private int mSize;

    public ByteBuffer(int size) {
        this.mArray = new byte[size];
    }

    @Override
    public void write(int b) {
        this.grow(this.mSize + 1);
        this.mArray[this.mSize] = (byte)b;
        ++this.mSize;
    }

    @Override
    public void write(@NonNull byte[] b, int offset, int length) {
        this.grow(this.mSize + length);
        System.arraycopy(b, offset, this.mArray, this.mSize, length);
        this.mSize += length;
    }

    private void grow(int capacity) {
        if (capacity > this.mArray.length) {
            int c = this.mArray.length * 2;
            if (c < capacity) {
                c = capacity;
            }
            if (c > 0x7FFFFFF7) {
                c = capacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
            }
            this.mArray = Arrays.copyOf(this.mArray, c);
        }
    }

    @NonNull
    public byte[] getArray() {
        return this.mArray;
    }

    public int getSize() {
        return this.mSize;
    }
}

