/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.TypedValue;
import com.budiyev.android.imageloader.CompressMode;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.MemoryImageCache;
import com.budiyev.android.imageloader.StorageImageCache;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutorService;

public final class DataUtils {
    private static final String HASH_ALGORITHM_SHA256 = "SHA-256";

    private DataUtils() {
    }

    @NonNull
    public static String generateSHA256(@NonNull String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(HASH_ALGORITHM_SHA256);
            messageDigest.update(string.getBytes());
            return new BigInteger(1, messageDigest.digest()).toString(36);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @WorkerThread
    public static Bitmap loadSampledBitmapFromUri(@NonNull Context context, @NonNull Uri uri, int requiredWidth, int requiredHeight, boolean ignoreTotalNumberOfPixels) throws IOException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        InputStream inputStream = null;
        try {
            inputStream = InternalUtils.getDataStreamFromUri(context, uri);
            if (inputStream == null) {
                Bitmap bitmap = null;
                return bitmap;
            }
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        }
        finally {
            InternalUtils.close(inputStream);
        }
        options.inJustDecodeBounds = false;
        options.inSampleSize = DataUtils.calculateSampleSize(options.outWidth, options.outHeight, requiredWidth, requiredHeight, ignoreTotalNumberOfPixels);
        inputStream = null;
        try {
            inputStream = InternalUtils.getDataStreamFromUri(context, uri);
            if (inputStream == null) {
                Bitmap bitmap = null;
                return bitmap;
            }
            inputStream = InternalUtils.buffer(inputStream);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        finally {
            InternalUtils.close(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @WorkerThread
    public static Bitmap loadSampledBitmapFromFile(@NonNull File file, int requiredWidth, int requiredHeight, boolean ignoreTotalNumberOfPixels) throws IOException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        }
        catch (Throwable throwable) {
            InternalUtils.close(inputStream);
            throw throwable;
        }
        InternalUtils.close(inputStream);
        options.inJustDecodeBounds = false;
        options.inSampleSize = DataUtils.calculateSampleSize(options.outWidth, options.outHeight, requiredWidth, requiredHeight, ignoreTotalNumberOfPixels);
        inputStream = null;
        try {
            inputStream = InternalUtils.buffer(new FileInputStream(file));
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        finally {
            InternalUtils.close(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @WorkerThread
    public static Bitmap loadSampledBitmapFromFileDescriptor(@NonNull FileDescriptor fileDescriptor, int requiredWidth, int requiredHeight, boolean ignoreTotalNumberOfPixels) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(fileDescriptor);
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        }
        catch (Throwable throwable) {
            InternalUtils.close(inputStream);
            throw throwable;
        }
        InternalUtils.close(inputStream);
        options.inJustDecodeBounds = false;
        options.inSampleSize = DataUtils.calculateSampleSize(options.outWidth, options.outHeight, requiredWidth, requiredHeight, ignoreTotalNumberOfPixels);
        inputStream = null;
        try {
            inputStream = InternalUtils.buffer(new FileInputStream(fileDescriptor));
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        finally {
            InternalUtils.close(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @WorkerThread
    public static Bitmap loadSampledBitmapFromResource(@NonNull Resources resources, int resourceId, int requiredWidth, int requiredHeight, boolean ignoreTotalNumberOfPixels) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        TypedValue typedValue = new TypedValue();
        options.inJustDecodeBounds = true;
        options.inTargetDensity = resources.getDisplayMetrics().densityDpi;
        if (typedValue.density == 0) {
            options.inDensity = 160;
        } else if (typedValue.density != 65535) {
            options.inDensity = typedValue.density;
        }
        InputStream inputStream = null;
        try {
            inputStream = resources.openRawResource(resourceId, typedValue);
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        }
        catch (Throwable throwable) {
            InternalUtils.close(inputStream);
            throw throwable;
        }
        InternalUtils.close(inputStream);
        options.inJustDecodeBounds = false;
        options.inSampleSize = DataUtils.calculateSampleSize(options.outWidth, options.outHeight, requiredWidth, requiredHeight, ignoreTotalNumberOfPixels);
        inputStream = null;
        try {
            inputStream = InternalUtils.buffer(resources.openRawResource(resourceId, typedValue));
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        finally {
            InternalUtils.close(inputStream);
        }
    }

    @Nullable
    @WorkerThread
    public static Bitmap loadSampledBitmapFromByteArray(@NonNull byte[] byteArray, int requiredWidth, int requiredHeight, boolean ignoreTotalNumberOfPixels) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length, (BitmapFactory.Options)options);
        options.inSampleSize = DataUtils.calculateSampleSize(options.outWidth, options.outHeight, requiredWidth, requiredHeight, ignoreTotalNumberOfPixels);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length, (BitmapFactory.Options)options);
    }

    private static int calculateSampleSize(int sourceWidth, int sourceHeight, int requiredWidth, int requiredHeight, boolean ignoreTotalNumberOfPixels) {
        int sampleSize = 1;
        if (sourceWidth > requiredWidth || sourceHeight > requiredHeight) {
            int halfWidth = sourceWidth / 2;
            int halfHeight = sourceHeight / 2;
            while (halfWidth / sampleSize > requiredWidth && halfHeight / sampleSize > requiredHeight) {
                sampleSize *= 2;
            }
            if (ignoreTotalNumberOfPixels) {
                return sampleSize;
            }
            int totalRequiredPixels = requiredWidth * requiredHeight;
            for (int totalPixels = sourceWidth * sourceHeight / (sampleSize * sampleSize); totalPixels > totalRequiredPixels; totalPixels /= 4) {
                sampleSize *= 2;
            }
        }
        return sampleSize;
    }

    @NonNull
    public static ImageCache memoryCache() {
        return new MemoryImageCache();
    }

    @NonNull
    public static ImageCache memoryCache(int maxSize) {
        return new MemoryImageCache(maxSize);
    }

    @NonNull
    public static ImageCache storageCache(@NonNull Context context) {
        return new StorageImageCache(context);
    }

    @NonNull
    public static ImageCache storageCache(@NonNull Context context, long maxSize) {
        return new StorageImageCache(context, maxSize);
    }

    @NonNull
    public static ImageCache storageCache(@NonNull Context context, @NonNull CompressMode compressMode, long maxSize) {
        return new StorageImageCache(context, compressMode, maxSize);
    }

    @NonNull
    public static ImageCache storageCache(@NonNull Context context, @NonNull ExecutorService executor, @NonNull CompressMode compressMode, long maxSize) {
        StorageImageCache cache = new StorageImageCache(context, compressMode, maxSize);
        cache.setExecutor(executor);
        return cache;
    }

    @NonNull
    public static ImageCache storageCache(@NonNull File directory) {
        return new StorageImageCache(directory);
    }

    @NonNull
    public static ImageCache storageCache(@NonNull File directory, long maxSize) {
        return new StorageImageCache(directory, maxSize);
    }

    @NonNull
    public static ImageCache storageCache(@NonNull File directory, @NonNull CompressMode compressMode, long maxSize) {
        return new StorageImageCache(directory, compressMode, maxSize);
    }

    @NonNull
    public static ImageCache storageCache(@NonNull ExecutorService executor, @NonNull File directory, @NonNull CompressMode compressMode, long maxSize) {
        StorageImageCache cache = new StorageImageCache(directory, compressMode, maxSize);
        cache.setExecutor(executor);
        return cache;
    }
}

