/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.graphics.Bitmap;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.LruCache;
import com.budiyev.android.imageloader.ImageCache;

final class MemoryImageCache
implements ImageCache {
    private static final float DEFAULT_MEMORY_FRACTION = 0.25f;
    private final LruCache<String, Bitmap> mCache;

    public MemoryImageCache() {
        this(Math.round((float)Runtime.getRuntime().maxMemory() * 0.25f));
    }

    public MemoryImageCache(int maxSize) {
        this.mCache = new InternalCacheImpl(maxSize);
    }

    @Override
    public void put(@NonNull String key, @NonNull Bitmap value) {
        this.mCache.put((Object)key, (Object)value);
    }

    @Override
    @Nullable
    public Bitmap get(@NonNull String key) {
        return (Bitmap)this.mCache.get((Object)key);
    }

    @Override
    public void remove(@NonNull String key) {
        this.mCache.remove((Object)key);
    }

    @Override
    public void clear() {
        this.mCache.evictAll();
    }

    private static final class InternalCacheImpl
    extends LruCache<String, Bitmap> {
        public InternalCacheImpl(int maxSize) {
            super(maxSize);
        }

        protected int sizeOf(String key, Bitmap value) {
            if (Build.VERSION.SDK_INT >= 19) {
                return value.getAllocationByteCount();
            }
            return value.getByteCount();
        }
    }
}

