/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.support.annotation.NonNull;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

final class ImageLoaderThreadFactory
implements ThreadFactory {
    private final AtomicInteger mCounter = new AtomicInteger(1);

    ImageLoaderThreadFactory() {
    }

    @Override
    @NonNull
    public Thread newThread(@NonNull Runnable r) {
        this.mCounter.compareAndSet(Integer.MAX_VALUE, 0);
        Thread t = new Thread(r, "ImageLoader thread #" + this.mCounter.getAndIncrement());
        if (t.getPriority() != 1) {
            t.setPriority(1);
        }
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        return t;
    }
}

