/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.widget.ImageView;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.BitmapProcessor;
import com.budiyev.android.imageloader.DataDescriptor;
import com.budiyev.android.imageloader.DisplayCallback;
import com.budiyev.android.imageloader.ErrorCallback;
import com.budiyev.android.imageloader.FadeDrawable;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.ImageNotLoadedException;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.LoadCallback;
import com.budiyev.android.imageloader.PauseLock;
import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

final class LoadImageAction<T> {
    private final Context mContext;
    private final Handler mMainThreadHandler;
    private final ExecutorService mExecutor;
    private final PauseLock mPauseLock;
    private final BitmapLoader<T> mBitmapLoader;
    private final BitmapProcessor<T> mBitmapProcessor;
    private final ImageCache mMemoryImageCache;
    private final ImageCache mStorageImageCache;
    private final LoadCallback<T> mLoadCallback;
    private final DisplayCallback<T> mDisplayCallback;
    private final ErrorCallback<T> mErrorCallback;
    private final DataDescriptor<T> mDescriptor;
    private final WeakReference<ImageView> mView;
    private final Drawable mPlaceholder;
    private final boolean mFadeEnabled;
    private final long mFadeDuration;
    private volatile Future<?> mFuture;
    private volatile boolean mCancelled;

    public LoadImageAction(@NonNull Context context, @NonNull Handler mainThreadHandler, @NonNull ExecutorService executor, @NonNull PauseLock pauseLock, @NonNull BitmapLoader<T> bitmapLoader, @Nullable BitmapProcessor<T> bitmapProcessor, @Nullable ImageCache memoryImageCache, @Nullable ImageCache storageImageCache, @Nullable LoadCallback<T> loadCallback, @Nullable DisplayCallback<T> displayCallback, @Nullable ErrorCallback<T> errorCallback, boolean fadeEnabled, long fadeDuration, @NonNull DataDescriptor<T> descriptor, @NonNull ImageView view, @NonNull Drawable placeholder) {
        this.mContext = context;
        this.mMainThreadHandler = mainThreadHandler;
        this.mExecutor = executor;
        this.mPauseLock = pauseLock;
        this.mBitmapLoader = bitmapLoader;
        this.mBitmapProcessor = bitmapProcessor;
        this.mMemoryImageCache = memoryImageCache;
        this.mStorageImageCache = storageImageCache;
        this.mLoadCallback = loadCallback;
        this.mDisplayCallback = displayCallback;
        this.mErrorCallback = errorCallback;
        this.mFadeEnabled = fadeEnabled;
        this.mFadeDuration = fadeDuration;
        this.mDescriptor = descriptor;
        this.mView = new WeakReference<ImageView>(view);
        this.mPlaceholder = placeholder;
    }

    public void execute() {
        if (this.mCancelled) {
            return;
        }
        this.mFuture = this.mExecutor.submit(new LoadImageTask());
    }

    public boolean hasSameDescriptor(@NonNull String descriptorKey) {
        return this.mDescriptor.getKey().equals(descriptorKey);
    }

    public void cancel() {
        this.mCancelled = true;
        Future<?> future = this.mFuture;
        if (future != null) {
            future.cancel(false);
        }
        this.mView.clear();
    }

    @WorkerThread
    private void loadImage() {
        BitmapProcessor<T> bitmapProcessor;
        ImageCache memoryImageCache;
        while (!this.mCancelled && this.mPauseLock.isPaused()) {
            if (!this.mPauseLock.await()) continue;
            return;
        }
        if (this.mCancelled) {
            return;
        }
        Bitmap image = null;
        ImageCache storageImageCache = this.mStorageImageCache;
        String key = this.mDescriptor.getKey();
        T data = this.mDescriptor.getData();
        if (storageImageCache != null) {
            image = storageImageCache.get(key);
        }
        if (image == null) {
            try {
                image = this.mBitmapLoader.load(this.mContext, data);
            }
            catch (Throwable error) {
                ErrorCallback<T> errorCallback = this.mErrorCallback;
                if (errorCallback != null) {
                    errorCallback.onError(this.mContext, data, error);
                }
                return;
            }
            if (image == null) {
                ErrorCallback<T> errorCallback = this.mErrorCallback;
                if (errorCallback != null) {
                    errorCallback.onError(this.mContext, data, new ImageNotLoadedException());
                }
                return;
            }
            if (this.mCancelled) {
                return;
            }
            if (storageImageCache != null) {
                storageImageCache.put(key, image);
            }
        }
        if (this.mCancelled) {
            return;
        }
        LoadCallback<T> loadCallback = this.mLoadCallback;
        if (loadCallback != null) {
            loadCallback.onLoaded(this.mContext, data, image);
        }
        if ((memoryImageCache = this.mMemoryImageCache) != null) {
            memoryImageCache.put(key, image);
        }
        if ((bitmapProcessor = this.mBitmapProcessor) != null) {
            image = bitmapProcessor.process(this.mContext, data, image);
        }
        if (this.mCancelled) {
            return;
        }
        this.mMainThreadHandler.post((Runnable)new SetImageAction(image));
    }

    private static final class FadeCallback<T>
    implements FadeDrawable.FadeCallback {
        private final Context mContext;
        private final DisplayCallback<T> mDisplayCallback;
        private final T mData;
        private final Bitmap mImage;
        private final ImageView mView;

        private FadeCallback(@NonNull Context context, @NonNull DisplayCallback<T> displayCallback, @NonNull T data, @NonNull Bitmap image, @NonNull ImageView view) {
            this.mContext = context;
            this.mDisplayCallback = displayCallback;
            this.mData = data;
            this.mImage = image;
            this.mView = view;
        }

        @Override
        public void onDone() {
            this.mDisplayCallback.onDisplayed(this.mContext, this.mData, this.mImage, this.mView);
        }
    }

    private final class SetImageAction
    implements Runnable {
        private final Bitmap mImage;

        public SetImageAction(Bitmap image) {
            this.mImage = image;
        }

        @Override
        @MainThread
        public void run() {
            if (LoadImageAction.this.mCancelled) {
                return;
            }
            ImageView view = (ImageView)LoadImageAction.this.mView.get();
            if (view == null || InternalUtils.getLoadImageAction(view) != LoadImageAction.this) {
                return;
            }
            DisplayCallback displayCallback = LoadImageAction.this.mDisplayCallback;
            Context context = LoadImageAction.this.mContext;
            Bitmap image = this.mImage;
            if (LoadImageAction.this.mFadeEnabled && Build.VERSION.SDK_INT >= 19) {
                view.setImageDrawable((Drawable)new FadeDrawable(LoadImageAction.this.mPlaceholder, (Drawable)new BitmapDrawable(context.getResources(), image), LoadImageAction.this.mFadeDuration, LoadImageAction.this.mMainThreadHandler, displayCallback == null ? null : new FadeCallback(context, displayCallback, LoadImageAction.this.mDescriptor.getData(), image, view)));
            } else {
                view.setImageBitmap(image);
                if (displayCallback != null) {
                    displayCallback.onDisplayed(context, LoadImageAction.this.mDescriptor.getData(), image, view);
                }
            }
        }
    }

    private final class LoadImageTask
    implements Callable<Void> {
        private LoadImageTask() {
        }

        @Override
        public Void call() throws Exception {
            LoadImageAction.this.loadImage();
            LoadImageAction.this.mFuture = null;
            return null;
        }
    }
}

