/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

final class FadeBitmapDrawable
extends BitmapDrawable {
    private static final int STATE_IDLE = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_DONE = 3;
    private static final int MAX_ALPHA = 255;
    private final Drawable mPlaceholder;
    private final long mDuration;
    private long mStartTime;
    private int mFadeState = 0;

    public FadeBitmapDrawable(@NonNull Resources resources, @NonNull Bitmap bitmap, @NonNull Drawable placeholder, long duration) {
        super(resources, bitmap);
        this.mPlaceholder = placeholder;
        this.mDuration = duration;
    }

    public void draw(@NonNull Canvas canvas) {
        switch (this.mFadeState) {
            case 0: {
                this.mPlaceholder.draw(canvas);
                this.mStartTime = SystemClock.uptimeMillis();
                this.mFadeState = 1;
                this.invalidateSelf();
                break;
            }
            case 1: {
                int alpha = Math.min(255, (int)(255.0f * ((float)(SystemClock.uptimeMillis() - this.mStartTime) / (float)this.mDuration)));
                if (alpha == 255) {
                    this.mFadeState = 3;
                    super.draw(canvas);
                    break;
                }
                int placeholderAlpha = this.mPlaceholder.getAlpha();
                this.mPlaceholder.setAlpha(255 - alpha);
                this.mPlaceholder.draw(canvas);
                this.mPlaceholder.setAlpha(placeholderAlpha);
                int imageAlpha = super.getAlpha();
                super.setAlpha(alpha);
                super.draw(canvas);
                super.setAlpha(imageAlpha);
                this.invalidateSelf();
                break;
            }
            case 3: {
                super.draw(canvas);
            }
        }
    }

    public void setAlpha(int alpha) {
        this.mPlaceholder.setAlpha(alpha);
        super.setAlpha(alpha);
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.mPlaceholder.setColorFilter(colorFilter);
        super.setColorFilter(colorFilter);
    }

    protected void onBoundsChange(@NonNull Rect bounds) {
        this.mPlaceholder.setBounds(bounds);
        super.onBoundsChange(bounds);
    }

    public int getOpacity() {
        switch (this.mFadeState) {
            case 0: {
                return this.mPlaceholder.getOpacity();
            }
            case 1: {
                return Math.min(this.mPlaceholder.getOpacity(), super.getOpacity());
            }
        }
        return super.getOpacity();
    }
}

