/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.widget.ImageView;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.BitmapProcessor;
import com.budiyev.android.imageloader.Callbacks;
import com.budiyev.android.imageloader.FadeBitmapDrawable;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.ImageSource;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.PauseLock;
import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

final class LoadImageAction<T> {
    private final Context mContext;
    private final Handler mMainThreadHandler;
    private final PauseLock mPauseLock;
    private final BitmapLoader<T> mBitmapLoader;
    private final BitmapProcessor<T> mBitmapProcessor;
    private final ImageCache mMemoryImageCache;
    private final ImageCache mStorageImageCache;
    private final Callbacks<T> mCallbacks;
    private final ImageSource<T> mSource;
    private final WeakReference<ImageView> mView;
    private final Drawable mPlaceholder;
    private final boolean mFadeEnabled;
    private final long mFadeDuration;
    private volatile Future<?> mFuture;
    private volatile boolean mCancelled;

    public LoadImageAction(@NonNull Context context, @NonNull Handler mainThreadHandler, @NonNull PauseLock pauseLock, @NonNull BitmapLoader<T> bitmapLoader, @Nullable BitmapProcessor<T> bitmapProcessor, @Nullable ImageCache memoryImageCache, @Nullable ImageCache storageImageCache, boolean fadeEnabled, long fadeDuration, @Nullable Callbacks<T> callbacks, @NonNull ImageSource<T> source, @NonNull ImageView view, @NonNull Drawable placeholder) {
        this.mContext = context;
        this.mMainThreadHandler = mainThreadHandler;
        this.mPauseLock = pauseLock;
        this.mBitmapLoader = bitmapLoader;
        this.mBitmapProcessor = bitmapProcessor;
        this.mMemoryImageCache = memoryImageCache;
        this.mStorageImageCache = storageImageCache;
        this.mCallbacks = callbacks;
        this.mFadeEnabled = fadeEnabled;
        this.mFadeDuration = fadeDuration;
        this.mSource = source;
        this.mView = new WeakReference<ImageView>(view);
        this.mPlaceholder = placeholder;
    }

    public void execute() {
        if (this.mCancelled) {
            return;
        }
        this.mFuture = InternalUtils.getImageLoaderExecutor().submit(new LoadImageTask());
    }

    @NonNull
    public ImageSource<T> getSource() {
        return this.mSource;
    }

    public void cancel() {
        this.mCancelled = true;
        Future<?> future = this.mFuture;
        if (future != null) {
            future.cancel(false);
        }
    }

    @WorkerThread
    private void loadImage() {
        BitmapProcessor<T> bitmapProcessor;
        while (!this.mCancelled && this.mPauseLock.isPaused()) {
            if (!this.mPauseLock.await()) continue;
            return;
        }
        if (this.mCancelled) {
            return;
        }
        Bitmap bitmap = null;
        ImageCache storageImageCache = this.mStorageImageCache;
        String key = this.mSource.getKey();
        T data = this.mSource.getData();
        if (storageImageCache != null) {
            bitmap = storageImageCache.get(key);
        }
        if (bitmap == null) {
            try {
                bitmap = this.mBitmapLoader.load(this.mContext, data);
            }
            catch (Throwable error) {
                Callbacks.notifyError(this.mCallbacks, data, error);
                return;
            }
            if (bitmap == null) {
                Callbacks.notifyError(this.mCallbacks, data, new Exception("Image is not loaded"));
                return;
            }
            if (storageImageCache != null) {
                storageImageCache.put(key, bitmap);
            }
        }
        Callbacks.notifyLoaded(this.mCallbacks, data, bitmap);
        if (this.mCancelled) {
            return;
        }
        ImageCache memoryImageCache = this.mMemoryImageCache;
        if (memoryImageCache != null) {
            memoryImageCache.put(key, bitmap);
        }
        if ((bitmapProcessor = this.mBitmapProcessor) != null) {
            bitmap = bitmapProcessor.process(this.mContext, data, bitmap);
        }
        if (this.mCancelled) {
            return;
        }
        this.mMainThreadHandler.post((Runnable)new SetImageAction(bitmap));
    }

    private final class SetImageAction
    implements Runnable {
        private final Bitmap mImage;

        public SetImageAction(Bitmap image) {
            this.mImage = image;
        }

        @Override
        @MainThread
        public void run() {
            if (LoadImageAction.this.mCancelled) {
                return;
            }
            ImageView view = (ImageView)LoadImageAction.this.mView.get();
            if (view == null || InternalUtils.getLoadImageAction(view) != LoadImageAction.this) {
                return;
            }
            if (LoadImageAction.this.mFadeEnabled) {
                view.setLayerType(1, null);
                view.setImageDrawable((Drawable)new FadeBitmapDrawable(LoadImageAction.this.mContext.getResources(), LoadImageAction.this.mPlaceholder, this.mImage, LoadImageAction.this.mFadeDuration));
            } else {
                view.setImageBitmap(this.mImage);
            }
        }
    }

    private final class LoadImageTask
    implements Callable<Void> {
        private LoadImageTask() {
        }

        @Override
        public Void call() throws Exception {
            LoadImageAction.this.loadImage();
            LoadImageAction.this.mFuture = null;
            return null;
        }
    }
}

