/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.support.annotation.NonNull;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

final class ImageLoaderThreadFactory
implements ThreadFactory {
    private static final AtomicInteger COUNTER = new AtomicInteger();

    ImageLoaderThreadFactory() {
    }

    @Override
    public Thread newThread(@NonNull Runnable runnable) {
        COUNTER.compareAndSet(Integer.MAX_VALUE, 0);
        Thread thread = new Thread(runnable, "ImageLoader thread #" + COUNTER.getAndIncrement());
        if (thread.getPriority() != 1) {
            thread.setPriority(1);
        }
        if (thread.isDaemon()) {
            thread.setDaemon(false);
        }
        return thread;
    }
}

