/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.StorageImageCache;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class StorageImageCacheImpl
implements StorageImageCache {
    private final Lock mCacheFitLock = new ReentrantLock();
    private final Comparator<File> mFileComparator;
    private final Runnable mFitCacheSizeTask;
    private final File mDirectory;
    private final Bitmap.CompressFormat mCompressFormat;
    private final int mCompressQuality;
    private final long mMaxSize;
    private volatile boolean mCacheFitting;
    private volatile boolean mCacheFitRequested;

    public StorageImageCacheImpl(@NonNull File directory, long maxSize, @NonNull Bitmap.CompressFormat compressFormat, int compressQuality) {
        this.mDirectory = directory;
        this.mCompressFormat = compressFormat;
        this.mCompressQuality = compressQuality;
        this.mMaxSize = maxSize;
        this.mFileComparator = new FileComparator();
        this.mFitCacheSizeTask = new FitCacheSizeTask();
        this.fitCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(@NonNull String key, @NonNull Bitmap value) {
        if (!this.mDirectory.exists()) {
            this.mDirectory.mkdirs();
        }
        File file = new File(this.mDirectory, key);
        this.deleteCacheFile(file);
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            value.compress(this.mCompressFormat, this.mCompressQuality, (OutputStream)outputStream);
        }
        catch (IOException e) {
            try {
                this.deleteCacheFile(file);
            }
            catch (Throwable throwable) {
                InternalUtils.close(outputStream);
                throw throwable;
            }
            InternalUtils.close(outputStream);
        }
        InternalUtils.close(outputStream);
        this.fitCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Bitmap get(@NonNull String key) {
        Bitmap bitmap;
        File file = new File(this.mDirectory, key);
        if (!file.exists() && !file.isFile()) {
            return null;
        }
        file.setLastModified(System.currentTimeMillis());
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
        }
        catch (IOException e) {
            Bitmap bitmap2;
            try {
                bitmap2 = null;
            }
            catch (Throwable throwable) {
                InternalUtils.close(inputStream);
                throw throwable;
            }
            InternalUtils.close(inputStream);
            return bitmap2;
        }
        InternalUtils.close(inputStream);
        return bitmap;
    }

    @Override
    public void remove(@NonNull String key) {
        this.deleteCacheFile(new File(this.mDirectory, key));
    }

    @Override
    public void clear() {
        File[] files = this.getCacheFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            file.delete();
        }
    }

    @Nullable
    private File[] getCacheFiles() {
        return this.mDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        });
    }

    private void deleteCacheFile(@NonNull File file) {
        if (file.exists() && file.isFile()) {
            file.delete();
        }
    }

    private void fitCache() {
        this.mCacheFitLock.lock();
        try {
            if (this.mCacheFitting) {
                this.mCacheFitRequested = true;
            } else {
                this.mCacheFitting = true;
                InternalUtils.getStorageCacheExecutor().execute(this.mFitCacheSizeTask);
            }
        }
        finally {
            this.mCacheFitLock.unlock();
        }
    }

    private static final class FileComparator
    implements Comparator<File> {
        private FileComparator() {
        }

        @Override
        public int compare(@NonNull File lhs, @NonNull File rhs) {
            return Long.signum(rhs.lastModified() - lhs.lastModified());
        }
    }

    private final class FitCacheSizeTask
    implements Runnable {
        private FitCacheSizeTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    File removing;
                    File[] files = StorageImageCacheImpl.this.getCacheFiles();
                    if (files == null || files.length < 2) {
                        return;
                    }
                    Arrays.sort(files, StorageImageCacheImpl.this.mFileComparator);
                    long size = 0L;
                    for (File file : files) {
                        size += file.length();
                    }
                    for (int i = files.length - 1; size > StorageImageCacheImpl.this.mMaxSize && i >= 0; size -= removing.length(), --i) {
                        removing = files[i];
                        removing.delete();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                StorageImageCacheImpl.this.mCacheFitLock.lock();
                try {
                    if (StorageImageCacheImpl.this.mCacheFitRequested) {
                        StorageImageCacheImpl.this.mCacheFitRequested = false;
                        continue;
                    }
                    StorageImageCacheImpl.this.mCacheFitting = false;
                }
                finally {
                    StorageImageCacheImpl.this.mCacheFitLock.unlock();
                    continue;
                }
                break;
            }
        }
    }
}

