/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import com.budiyev.android.imageloader.R;
import com.budiyev.android.imageloader.RecyclingBitmapDrawable;

public class RecyclingImageView
extends AppCompatImageView {
    private boolean mClearDrawableOnDetach;

    public RecyclingImageView(@NonNull Context context) {
        super(context);
        this.initialize(context, null, 0);
    }

    public RecyclingImageView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs, 0);
    }

    public RecyclingImageView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(@NonNull Context context, @Nullable AttributeSet attributeSet, @AttrRes int defStyleAttr) {
        if (attributeSet != null) {
            TypedArray attributes = null;
            try {
                attributes = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.RecyclingImageView, defStyleAttr, 0);
                this.mClearDrawableOnDetach = attributes.getBoolean(R.styleable.RecyclingImageView_clearDrawableOnDetach, false);
            }
            finally {
                if (attributes != null) {
                    attributes.recycle();
                }
            }
        }
    }

    private void notifyDrawable(Drawable drawable, boolean displayed) {
        if (drawable instanceof RecyclingBitmapDrawable) {
            ((RecyclingBitmapDrawable)drawable).setDisplayed(displayed);
        } else if (drawable instanceof LayerDrawable) {
            LayerDrawable layerDrawable = (LayerDrawable)drawable;
            int z = layerDrawable.getNumberOfLayers();
            for (int i = 0; i < z; ++i) {
                this.notifyDrawable(layerDrawable.getDrawable(i), displayed);
            }
        }
    }

    protected void onDetachedFromWindow() {
        if (this.mClearDrawableOnDetach) {
            this.setImageDrawable(null);
        }
        super.onDetachedFromWindow();
    }

    public void setImageDrawable(Drawable drawable) {
        Drawable previousDrawable = this.getDrawable();
        super.setImageDrawable(drawable);
        this.notifyDrawable(drawable, true);
        this.notifyDrawable(previousDrawable, false);
    }

    public void setClearDrawableOnDetach(boolean clearDrawableOnDetach) {
        this.mClearDrawableOnDetach = clearDrawableOnDetach;
    }
}

