/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.support.annotation.NonNull;
import com.budiyev.android.imageloader.ImageLoaderUtils;
import com.budiyev.android.imageloader.ImageSource;
import com.budiyev.android.imageloader.InternalUtils;

final class ImageSourceImpl<T>
implements ImageSource<T> {
    private final T mData;
    private final String mKey;

    public ImageSourceImpl(@NonNull T data) {
        this.mData = InternalUtils.requireNonNull(data);
        this.mKey = ImageLoaderUtils.generateSHA256(data.toString());
    }

    @Override
    @NonNull
    public T getData() {
        return this.mData;
    }

    @Override
    @NonNull
    public String getKey() {
        return this.mKey;
    }

    public int hashCode() {
        return this.mKey.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ImageSourceImpl && InternalUtils.equals(this.mKey, ((ImageSourceImpl)obj).mKey);
    }

    @NonNull
    public String toString() {
        return "ImageSource [key: " + this.mKey + ", data: " + this.mData + "]";
    }
}

