/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import com.budiyev.android.imageloader.InternalUtils;

@RequiresApi(value=19)
public class FadeDrawable
extends LayerDrawable
implements Drawable.Callback {
    private static final int FADE_NONE = 0;
    private static final int FADE_RUNNING = 1;
    private static final int FADE_DONE = 2;
    private static final int START_DRAWABLE = 0;
    private static final int END_DRAWABLE = 1;
    private static final int MAX_ALPHA = 255;
    private int mFadeState = 0;
    private long mStartTime;
    private long mDuration;
    private FadeStartListener mFadeStartListener;
    private FadeEndListener mFadeEndListener;

    public FadeDrawable(@NonNull Drawable startDrawable, @NonNull Drawable endDrawable) {
        super(new Drawable[]{startDrawable, endDrawable});
        this.setId(0, 0);
        this.setId(1, 1);
    }

    private void draw(Canvas canvas, Drawable drawable, int alpha) {
        int originalAlpha = drawable.getAlpha();
        drawable.setAlpha(alpha);
        drawable.draw(canvas);
        drawable.setAlpha(originalAlpha);
    }

    public void draw(Canvas canvas) {
        if (this.mFadeState == 1) {
            int alpha = Math.min(Math.round(255.0f * (float)(System.currentTimeMillis() - this.mStartTime) / (float)this.mDuration), 255);
            this.draw(canvas, this.getStartDrawable(), 255 - alpha);
            this.draw(canvas, this.getEndDrawable(), alpha);
            if (alpha == 255) {
                this.mFadeState = 2;
                FadeEndListener fadeEndListener = this.mFadeEndListener;
                if (fadeEndListener != null) {
                    InternalUtils.runOnMainThread(new FadeEndCallback(fadeEndListener));
                }
            } else {
                this.invalidateSelf();
            }
        } else if (this.mFadeState == 0) {
            this.draw(canvas, this.getStartDrawable(), 255);
        } else if (this.mFadeState == 2) {
            this.draw(canvas, this.getEndDrawable(), 255);
        }
    }

    public void startFade(int duration) {
        this.mDuration = duration;
        this.mStartTime = System.currentTimeMillis();
        this.mFadeState = 1;
        this.invalidateSelf();
        FadeStartListener fadeStartListener = this.mFadeStartListener;
        if (fadeStartListener != null) {
            InternalUtils.runOnMainThread(new FadeStartCallback(fadeStartListener));
        }
    }

    public void resetFade() {
        this.mFadeState = 0;
        this.invalidateSelf();
    }

    @NonNull
    public Drawable getStartDrawable() {
        return this.getDrawable(0);
    }

    public void setStartDrawable(@Nullable Drawable startDrawable) {
        this.setDrawableByLayerId(0, startDrawable);
    }

    @NonNull
    public Drawable getEndDrawable() {
        return this.getDrawable(1);
    }

    public void setEndDrawable(@Nullable Drawable endDrawable) {
        this.setDrawableByLayerId(1, endDrawable);
    }

    @Nullable
    public FadeStartListener getFadeStartListener() {
        return this.mFadeStartListener;
    }

    public void setFadeStartListener(@Nullable FadeStartListener listener) {
        this.mFadeStartListener = listener;
    }

    @Nullable
    public FadeEndListener getFadeEndListener() {
        return this.mFadeEndListener;
    }

    public void setFadeEndListener(@Nullable FadeEndListener listener) {
        this.mFadeEndListener = listener;
    }

    private final class FadeEndCallback
    implements Runnable {
        private final FadeEndListener mListener;

        private FadeEndCallback(FadeEndListener listener) {
            this.mListener = listener;
        }

        @Override
        public void run() {
            this.mListener.onEnd(FadeDrawable.this);
        }
    }

    private final class FadeStartCallback
    implements Runnable {
        private final FadeStartListener mListener;

        private FadeStartCallback(FadeStartListener listener) {
            this.mListener = listener;
        }

        @Override
        public void run() {
            this.mListener.onStart(FadeDrawable.this);
        }
    }

    public static interface FadeEndListener {
        @MainThread
        public void onEnd(@NonNull FadeDrawable var1);
    }

    public static interface FadeStartListener {
        @MainThread
        public void onStart(@NonNull FadeDrawable var1);
    }
}

