/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.budiyev.android.imageloader.Callbacks;
import com.budiyev.android.imageloader.FadeDrawable;
import com.budiyev.android.imageloader.ImageLoader;
import com.budiyev.android.imageloader.ImageSource;
import com.budiyev.android.imageloader.LoadImageAction;

final class SetImageAction<T>
implements Runnable {
    private final BitmapDrawable mBitmapDrawable;
    private final ImageLoader<T> mImageLoader;
    private final LoadImageAction<T> mLoadImageAction;
    private final Callbacks<T> mCallbacks;

    public SetImageAction(@Nullable BitmapDrawable bitmapDrawable, @NonNull ImageLoader<T> imageLoader, @Nullable Callbacks<T> callbacks, @NonNull LoadImageAction<T> loadImageAction) {
        this.mBitmapDrawable = bitmapDrawable;
        this.mImageLoader = imageLoader;
        this.mCallbacks = callbacks;
        this.mLoadImageAction = loadImageAction;
    }

    @Override
    @MainThread
    public void run() {
        if (!this.mLoadImageAction.isCancelled() && !this.mImageLoader.isExitTasksEarly()) {
            View view = this.mLoadImageAction.getAttachedView();
            if (this.mBitmapDrawable == null || view == null) {
                return;
            }
            ImageSource<T> source = this.mLoadImageAction.getImageSource();
            if (this.mImageLoader.isImageFadeIn() && Build.VERSION.SDK_INT >= 19) {
                FadeDrawable fadeDrawable = new FadeDrawable(this.mImageLoader.getPlaceholderDrawable(source), (Drawable)this.mBitmapDrawable);
                this.mImageLoader.setDrawable(view, (Drawable)fadeDrawable);
                fadeDrawable.setFadeEndListener(new FadeEndListener<T>(this.mCallbacks, source, this.mBitmapDrawable, view));
                fadeDrawable.startFade(this.mImageLoader.getImageFadeInTime());
            } else {
                this.mImageLoader.setDrawable(view, (Drawable)this.mBitmapDrawable);
                Callbacks.notifyDisplayed(this.mCallbacks, source, this.mBitmapDrawable, view);
            }
        }
    }

    private static final class FadeEndListener<T>
    implements FadeDrawable.FadeEndListener {
        private final Callbacks<T> mCallbacks;
        private final ImageSource<T> mSource;
        private final BitmapDrawable mDrawable;
        private final View mView;

        public FadeEndListener(@Nullable Callbacks<T> callbacks, @NonNull ImageSource<T> source, @NonNull BitmapDrawable drawable, @NonNull View view) {
            this.mCallbacks = callbacks;
            this.mSource = source;
            this.mDrawable = drawable;
            this.mView = view;
        }

        @Override
        public void onEnd(@NonNull FadeDrawable drawable) {
            Callbacks.notifyDisplayed(this.mCallbacks, this.mSource, this.mDrawable, this.mView);
        }
    }
}

