/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import java.io.InputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class RecyclingBitmapDrawable
extends BitmapDrawable {
    private final Lock mRecycleLock = new ReentrantLock();
    private volatile int mDisplayReferencesCount;
    private volatile int mCacheReferencesCount;
    private volatile boolean mHasBeenDisplayed;

    public RecyclingBitmapDrawable(Resources resources, Bitmap bitmap) {
        super(resources, bitmap);
    }

    public RecyclingBitmapDrawable(Resources resources, String filePath) {
        super(resources, filePath);
    }

    public RecyclingBitmapDrawable(Resources resources, InputStream inputStream) {
        super(resources, inputStream);
    }

    public void setDisplayed(boolean displayed) {
        this.mRecycleLock.lock();
        try {
            if (displayed) {
                ++this.mDisplayReferencesCount;
                this.mHasBeenDisplayed = true;
            } else {
                --this.mCacheReferencesCount;
            }
            this.checkStateAndRecycleIfNeeded();
        }
        finally {
            this.mRecycleLock.unlock();
        }
    }

    public void setCached(boolean cached) {
        this.mRecycleLock.lock();
        try {
            this.mCacheReferencesCount = cached ? ++this.mCacheReferencesCount : --this.mCacheReferencesCount;
            this.checkStateAndRecycleIfNeeded();
        }
        finally {
            this.mRecycleLock.unlock();
        }
    }

    private void checkStateAndRecycleIfNeeded() {
        Bitmap bitmap = this.getBitmap();
        if (bitmap != null && !bitmap.isRecycled() && this.mCacheReferencesCount <= 0 && this.mDisplayReferencesCount <= 0 && this.mHasBeenDisplayed) {
            bitmap.recycle();
        }
    }
}

