/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.graphics.drawable.BitmapDrawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.LruCache;
import com.budiyev.android.imageloader.MemoryImageCache;
import com.budiyev.android.imageloader.RecyclingBitmapDrawable;

final class MemoryImageCacheImpl
implements MemoryImageCache {
    private final LruCache<String, BitmapDrawable> mCache;

    public MemoryImageCacheImpl(int size) {
        this.mCache = new LruCache<String, BitmapDrawable>(size){

            protected void entryRemoved(boolean evicted, String key, BitmapDrawable oldValue, BitmapDrawable newValue) {
                if (oldValue instanceof RecyclingBitmapDrawable) {
                    ((RecyclingBitmapDrawable)oldValue).setCached(false);
                }
            }

            protected int sizeOf(String key, BitmapDrawable value) {
                if (Build.VERSION.SDK_INT >= 19) {
                    return value.getBitmap().getAllocationByteCount();
                }
                return value.getBitmap().getByteCount();
            }
        };
    }

    @Override
    public void put(@NonNull String key, @NonNull BitmapDrawable value) {
        if (value instanceof RecyclingBitmapDrawable) {
            ((RecyclingBitmapDrawable)value).setCached(true);
        }
        this.mCache.put((Object)key, (Object)value);
    }

    @Override
    @Nullable
    public BitmapDrawable get(@NonNull String key) {
        return (BitmapDrawable)this.mCache.get((Object)key);
    }

    @Override
    public void remove(@NonNull String key) {
        this.mCache.remove((Object)key);
    }

    @Override
    public void clear() {
        this.mCache.evictAll();
    }
}

