/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.codescanner;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.budiyev.android.codescanner.Point;
import com.budiyev.android.codescanner.Rect;
import com.budiyev.android.codescanner.Utils;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;

final class DecodeTask {
    private final byte[] mImage;
    private final Point mImageSize;
    private final Point mPreviewSize;
    private final Point mViewSize;
    private final Rect mViewFrameRect;
    private final int mOrientation;
    private final boolean mReverseHorizontal;

    public DecodeTask(@NonNull byte[] image, @NonNull Point imageSize, @NonNull Point previewSize, @NonNull Point viewSize, @NonNull Rect viewFrameRect, int orientation, boolean reverseHorizontal) {
        this.mImage = image;
        this.mImageSize = imageSize;
        this.mPreviewSize = previewSize;
        this.mViewSize = viewSize;
        this.mViewFrameRect = viewFrameRect;
        this.mOrientation = orientation;
        this.mReverseHorizontal = reverseHorizontal;
    }

    @Nullable
    public Result decode(@NonNull MultiFormatReader reader) throws ReaderException {
        int imageWidth = this.mImageSize.getX();
        int imageHeight = this.mImageSize.getY();
        int orientation = this.mOrientation;
        byte[] image = Utils.rotateYuv(this.mImage, imageWidth, imageHeight, orientation);
        if (orientation == 90 || orientation == 270) {
            int width = imageWidth;
            imageWidth = imageHeight;
            imageHeight = width;
        }
        Rect frameRect = Utils.getImageFrameRect(imageWidth, imageHeight, this.mViewFrameRect, this.mPreviewSize, this.mViewSize);
        int frameWidth = frameRect.getWidth();
        int frameHeight = frameRect.getHeight();
        if (frameWidth < 1 || frameHeight < 1) {
            return null;
        }
        return Utils.decodeLuminanceSource(reader, (LuminanceSource)new PlanarYUVLuminanceSource(image, imageWidth, imageHeight, frameRect.getLeft(), frameRect.getTop(), frameWidth, frameHeight, this.mReverseHorizontal));
    }
}

