/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.codescanner;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Px;
import android.view.View;
import com.budiyev.android.codescanner.Rect;
import com.budiyev.android.codescanner.Utils;

final class ViewFinderView
extends View {
    private static final float MAX_FRAME_SIZE = 0.75f;
    private final Paint mMaskPaint = new Paint(1);
    private final Paint mFramePaint = new Paint(1);
    private final Path mFramePath;
    private Rect mFrameRect;
    private int mFrameCornerSize;
    private float mFrameRatioWidth = 1.0f;
    private float mFrameRatioHeight = 1.0f;

    public ViewFinderView(@NonNull Context context) {
        super(context);
        this.mFramePaint.setStyle(Paint.Style.STROKE);
        this.mFramePath = new Path();
    }

    protected void onDraw(@NonNull Canvas canvas) {
        Rect frameRect = this.mFrameRect;
        if (frameRect == null) {
            return;
        }
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        int top = frameRect.getTop();
        int left = frameRect.getLeft();
        int right = frameRect.getRight();
        int bottom = frameRect.getBottom();
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)top, this.mMaskPaint);
        canvas.drawRect(0.0f, (float)top, (float)left, (float)bottom, this.mMaskPaint);
        canvas.drawRect((float)right, (float)top, (float)width, (float)bottom, this.mMaskPaint);
        canvas.drawRect(0.0f, (float)bottom, (float)width, (float)height, this.mMaskPaint);
        this.mFramePath.reset();
        this.mFramePath.moveTo((float)left, (float)(top + this.mFrameCornerSize));
        this.mFramePath.lineTo((float)left, (float)top);
        this.mFramePath.lineTo((float)(left + this.mFrameCornerSize), (float)top);
        this.mFramePath.moveTo((float)(right - this.mFrameCornerSize), (float)top);
        this.mFramePath.lineTo((float)right, (float)top);
        this.mFramePath.lineTo((float)right, (float)(top + this.mFrameCornerSize));
        this.mFramePath.moveTo((float)right, (float)(bottom - this.mFrameCornerSize));
        this.mFramePath.lineTo((float)right, (float)bottom);
        this.mFramePath.lineTo((float)(right - this.mFrameCornerSize), (float)bottom);
        this.mFramePath.moveTo((float)(left + this.mFrameCornerSize), (float)bottom);
        this.mFramePath.lineTo((float)left, (float)bottom);
        this.mFramePath.lineTo((float)left, (float)(bottom - this.mFrameCornerSize));
        canvas.drawPath(this.mFramePath, this.mFramePaint);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.invalidateFrameRect(right - left, bottom - top);
    }

    @Nullable
    Rect getFrameRect() {
        return this.mFrameRect;
    }

    void setFrameAspectRatio(@FloatRange(from=0.0, fromInclusive=false) float ratioWidth, @FloatRange(from=0.0, fromInclusive=false) float ratioHeight) {
        this.mFrameRatioWidth = ratioWidth;
        this.mFrameRatioHeight = ratioHeight;
        this.invalidateFrameRect();
        if (Utils.isLaidOut(this)) {
            this.invalidate();
        }
    }

    void setFrameRatioWidth(@FloatRange(from=0.0, fromInclusive=false) float ratioWidth) {
        this.mFrameRatioWidth = ratioWidth;
        this.invalidateFrameRect();
        if (Utils.isLaidOut(this)) {
            this.invalidate();
        }
    }

    void setFrameRatioHeight(@FloatRange(from=0.0, fromInclusive=false) float ratioHeight) {
        this.mFrameRatioHeight = ratioHeight;
        this.invalidateFrameRect();
        if (Utils.isLaidOut(this)) {
            this.invalidate();
        }
    }

    void setMaskColor(@ColorInt int color) {
        this.mMaskPaint.setColor(color);
        if (Utils.isLaidOut(this)) {
            this.invalidate();
        }
    }

    void setFrameColor(@ColorInt int color) {
        this.mFramePaint.setColor(color);
        if (Utils.isLaidOut(this)) {
            this.invalidate();
        }
    }

    void setFrameThickness(@Px int thickness) {
        this.mFramePaint.setStrokeWidth((float)thickness);
        if (Utils.isLaidOut(this)) {
            this.invalidate();
        }
    }

    void setFrameCornersSize(@Px int size) {
        this.mFrameCornerSize = size;
        if (Utils.isLaidOut(this)) {
            this.invalidate();
        }
    }

    private void invalidateFrameRect() {
        this.invalidateFrameRect(this.getWidth(), this.getHeight());
    }

    private void invalidateFrameRect(int width, int height) {
        if (width > 0 && height > 0) {
            int frameHeight;
            int frameWidth;
            float viewAR = (float)width / (float)height;
            float frameAR = this.mFrameRatioWidth / this.mFrameRatioHeight;
            if (viewAR <= frameAR) {
                frameWidth = Math.round((float)width * 0.75f);
                frameHeight = Math.round((float)frameWidth / frameAR);
            } else {
                frameHeight = Math.round((float)height * 0.75f);
                frameWidth = Math.round((float)frameHeight * frameAR);
            }
            int frameLeft = (width - frameWidth) / 2;
            int frameTop = (height - frameHeight) / 2;
            this.mFrameRect = new Rect(frameLeft, frameTop, frameLeft + frameWidth, frameTop + frameHeight);
        }
    }
}

