/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.codescanner;

import android.content.Context;
import android.graphics.Point;
import android.hardware.Camera;
import android.os.Handler;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.SurfaceHolder;
import android.view.View;
import com.budiyev.android.codescanner.CodeScannerView;
import com.budiyev.android.codescanner.DecodeCallback;
import com.budiyev.android.codescanner.Decoder;
import com.budiyev.android.codescanner.Utils;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.client.android.camera.CameraConfigurationUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class CodeScanner {
    public static final List<BarcodeFormat> ALL_FORMATS = Arrays.asList(BarcodeFormat.AZTEC, BarcodeFormat.CODABAR, BarcodeFormat.CODE_39, BarcodeFormat.CODE_93, BarcodeFormat.CODE_128, BarcodeFormat.DATA_MATRIX, BarcodeFormat.EAN_8, BarcodeFormat.EAN_13, BarcodeFormat.ITF, BarcodeFormat.MAXICODE, BarcodeFormat.PDF_417, BarcodeFormat.QR_CODE, BarcodeFormat.RSS_14, BarcodeFormat.RSS_EXPANDED, BarcodeFormat.UPC_A, BarcodeFormat.UPC_E, BarcodeFormat.UPC_EAN_EXTENSION);
    public static final List<BarcodeFormat> ONE_DIMENSIONAL_FORMATS = Arrays.asList(BarcodeFormat.CODABAR, BarcodeFormat.CODE_39, BarcodeFormat.CODE_93, BarcodeFormat.CODE_128, BarcodeFormat.EAN_8, BarcodeFormat.EAN_13, BarcodeFormat.ITF, BarcodeFormat.RSS_14, BarcodeFormat.RSS_EXPANDED, BarcodeFormat.UPC_A, BarcodeFormat.UPC_E, BarcodeFormat.UPC_EAN_EXTENSION);
    public static final List<BarcodeFormat> TWO_DIMENSIONAL_FORMATS = Arrays.asList(BarcodeFormat.AZTEC, BarcodeFormat.DATA_MATRIX, BarcodeFormat.MAXICODE, BarcodeFormat.PDF_417, BarcodeFormat.QR_CODE);
    private static final long AUTO_FOCUS_INTERVAL = 1000L;
    private static final int UNSPECIFIED = -1;
    private final Lock mInitializeLock = new ReentrantLock();
    private final Context mContext;
    private final Handler mMainThreadHandler;
    private final CodeScannerView mScannerView;
    private final SurfaceHolder mSurfaceHolder;
    private final SurfaceHolder.Callback mSurfaceCallback;
    private final Camera.PreviewCallback mPreviewCallback;
    private final Camera.AutoFocusCallback mAutoFocusCallback;
    private final Runnable mAutoFocusTask;
    private final Runnable mStopPreviewTask;
    private final int mCameraId;
    private volatile List<BarcodeFormat> mFormats = ALL_FORMATS;
    private volatile DecodeCallback mDecodeCallback;
    private volatile Camera mCamera;
    private volatile Decoder mDecoder;
    private volatile Point mPreviewSize;
    private volatile Point mFrameSize;
    private volatile int mDisplayOrientation;
    private volatile boolean mInitialization;
    private volatile boolean mInitialized;
    private volatile boolean mStoppingPreview;
    private boolean mPreviewActive;
    private boolean mSurfaceAvailable;
    private boolean mFocusing;

    @MainThread
    public CodeScanner(@NonNull Context context, @NonNull CodeScannerView view) {
        this(context, view, -1);
    }

    @MainThread
    public CodeScanner(@NonNull Context context, @NonNull CodeScannerView view, int cameraId) {
        this.mContext = context;
        this.mScannerView = view;
        this.mSurfaceHolder = view.getPreviewView().getHolder();
        this.mMainThreadHandler = new Handler();
        this.mSurfaceCallback = new SurfaceCallback();
        this.mPreviewCallback = new PreviewCallback();
        this.mAutoFocusCallback = new AutoFocusCallback();
        this.mAutoFocusTask = new AutoFocusTask();
        this.mStopPreviewTask = new StopPreviewTask();
        this.mCameraId = cameraId;
    }

    public void setFormats(@NonNull List<BarcodeFormat> formats) {
        this.mInitializeLock.lock();
        try {
            if (this.mInitialized) {
                this.mDecoder.setFormats(formats);
            } else {
                this.mFormats = formats;
            }
        }
        finally {
            this.mInitializeLock.unlock();
        }
    }

    public void setFormat(@NonNull BarcodeFormat format) {
        this.setFormats(Collections.singletonList(format));
    }

    public void setDecodeCallback(@Nullable DecodeCallback decodeCallback) {
        this.mDecodeCallback = decodeCallback;
    }

    public boolean isPreviewActive() {
        return this.mPreviewActive;
    }

    @MainThread
    public void startPreview() {
        this.mInitializeLock.lock();
        try {
            if (!this.mInitialized && !this.mInitialization) {
                this.mInitialization = true;
                this.initialize();
                return;
            }
        }
        finally {
            this.mInitializeLock.unlock();
        }
        if (!this.mPreviewActive) {
            this.mSurfaceHolder.addCallback(this.mSurfaceCallback);
            this.startPreviewInternal();
        }
    }

    @MainThread
    public void stopPreview() {
        if (this.mInitialized && this.mPreviewActive) {
            this.mSurfaceHolder.removeCallback(this.mSurfaceCallback);
            this.stopPreviewInternal();
        }
    }

    @MainThread
    public void releaseResources() {
        this.mPreviewActive = false;
        if (this.mInitialized) {
            this.mCamera.release();
            this.mDecoder.shutdown();
        }
    }

    private void initialize() {
        if (Utils.isLaidOut((View)this.mScannerView)) {
            this.initialize(this.mScannerView.getWidth(), this.mScannerView.getHeight());
        } else {
            this.mScannerView.setLayoutListener(new ScannerLayoutListener());
        }
    }

    private void initialize(int width, int height) {
        new InitializationThread(width, height).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishInitialization(@NonNull Camera camera, @NonNull Point previewSize, @NonNull Point frameSize, int displayOrientation) {
        this.mInitializeLock.lock();
        try {
            this.mCamera = camera;
            this.mDecoder = new Decoder(new DecoderStateListener());
            this.mDecoder.setFormats(this.mFormats);
            this.mDecoder.start();
            this.mPreviewSize = previewSize;
            this.mFrameSize = frameSize;
            this.mDisplayOrientation = displayOrientation;
            this.mInitialization = false;
            this.mInitialized = true;
        }
        finally {
            this.mInitializeLock.unlock();
        }
        this.mMainThreadHandler.post((Runnable)new FinishInitializationTask(frameSize));
    }

    private void startPreviewInternal() {
        try {
            this.mCamera.setPreviewCallback(this.mPreviewCallback);
            this.mCamera.setPreviewDisplay(this.mSurfaceHolder);
            this.mCamera.startPreview();
            this.mStoppingPreview = false;
            this.mPreviewActive = true;
            this.mFocusing = false;
            this.autoFocusCamera();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stopPreviewInternal() {
        this.mCamera.setPreviewCallback(null);
        try {
            this.mCamera.stopPreview();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mStoppingPreview = false;
        this.mPreviewActive = false;
        this.mFocusing = false;
    }

    private void autoFocusCamera() {
        if (!this.mInitialized || !this.mPreviewActive) {
            return;
        }
        if (!this.mSurfaceAvailable || this.mFocusing) {
            this.scheduleAutoFocusTask();
            return;
        }
        try {
            this.mCamera.autoFocus(this.mAutoFocusCallback);
            this.mFocusing = true;
        }
        catch (Exception e) {
            this.mFocusing = false;
            this.scheduleAutoFocusTask();
        }
    }

    private void scheduleAutoFocusTask() {
        this.mMainThreadHandler.postDelayed(this.mAutoFocusTask, 1000L);
    }

    private final class FinishInitializationTask
    implements Runnable {
        private final Point mFrameSize;

        private FinishInitializationTask(Point frameSize) {
            this.mFrameSize = frameSize;
        }

        @Override
        public void run() {
            CodeScanner.this.mScannerView.setFrameSize(this.mFrameSize);
            CodeScanner.this.startPreview();
        }
    }

    private final class StopPreviewTask
    implements Runnable {
        private StopPreviewTask() {
        }

        @Override
        public void run() {
            CodeScanner.this.stopPreview();
        }
    }

    private final class AutoFocusTask
    implements Runnable {
        private AutoFocusTask() {
        }

        @Override
        public void run() {
            CodeScanner.this.autoFocusCamera();
        }
    }

    private final class AutoFocusCallback
    implements Camera.AutoFocusCallback {
        private AutoFocusCallback() {
        }

        public void onAutoFocus(boolean success, Camera camera) {
            CodeScanner.this.mFocusing = false;
            CodeScanner.this.scheduleAutoFocusTask();
        }
    }

    private final class InitializationThread
    extends Thread {
        private final int mWidth;
        private final int mHeight;

        public InitializationThread(int width, int height) {
            super("Code scanner initialization thread");
            if (this.isDaemon()) {
                this.setDaemon(false);
            }
            this.mWidth = width;
            this.mHeight = height;
        }

        @Override
        public void run() {
            Camera camera = null;
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            if (CodeScanner.this.mCameraId == -1) {
                int numberOfCameras = Camera.getNumberOfCameras();
                for (int i = 0; i < numberOfCameras; ++i) {
                    Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
                    if (cameraInfo.facing != 0) continue;
                    camera = Camera.open((int)i);
                    break;
                }
            } else {
                camera = Camera.open((int)CodeScanner.this.mCameraId);
                Camera.getCameraInfo((int)CodeScanner.this.mCameraId, (Camera.CameraInfo)cameraInfo);
            }
            if (camera == null) {
                throw new RuntimeException("Unable to access camera");
            }
            Camera.Parameters parameters = camera.getParameters();
            if (parameters == null) {
                throw new RuntimeException("Unable to configure camera");
            }
            int orientation = Utils.getDisplayOrientation(CodeScanner.this.mContext, cameraInfo);
            boolean portrait = Utils.isPortrait(orientation);
            Point previewSize = CameraConfigurationUtils.findBestPreviewSizeValue((Camera.Parameters)parameters, (Point)(portrait ? new Point(this.mHeight, this.mWidth) : new Point(this.mWidth, this.mHeight)));
            parameters.setPreviewSize(previewSize.x, previewSize.y);
            Point frameSize = Utils.getFrameSize(portrait ? previewSize.y : previewSize.x, portrait ? previewSize.x : previewSize.y, this.mWidth, this.mHeight);
            camera.setParameters(Utils.optimizeParameters(parameters));
            camera.setDisplayOrientation(orientation);
            CodeScanner.this.finishInitialization(camera, previewSize, frameSize, orientation);
        }
    }

    private final class DecoderStateListener
    implements Decoder.StateListener {
        private DecoderStateListener() {
        }

        @Override
        public void onStateChanged(int state) {
            if (state == 2) {
                CodeScanner.this.mStoppingPreview = true;
                CodeScanner.this.mMainThreadHandler.post(CodeScanner.this.mStopPreviewTask);
            }
        }
    }

    private final class SurfaceCallback
    implements SurfaceHolder.Callback {
        private SurfaceCallback() {
        }

        public void surfaceCreated(SurfaceHolder holder) {
            CodeScanner.this.mSurfaceAvailable = true;
            CodeScanner.this.startPreviewInternal();
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            if (holder.getSurface() == null) {
                CodeScanner.this.mPreviewActive = false;
                return;
            }
            CodeScanner.this.mSurfaceAvailable = true;
            CodeScanner.this.stopPreviewInternal();
            CodeScanner.this.startPreviewInternal();
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            CodeScanner.this.mSurfaceAvailable = false;
            CodeScanner.this.stopPreviewInternal();
        }
    }

    private final class PreviewCallback
    implements Camera.PreviewCallback {
        private PreviewCallback() {
        }

        public void onPreviewFrame(byte[] data, Camera camera) {
            if (!CodeScanner.this.mInitialized || CodeScanner.this.mStoppingPreview || CodeScanner.this.mDecoder.isProcessing()) {
                return;
            }
            Point previewSize = CodeScanner.this.mPreviewSize;
            Point frameSize = CodeScanner.this.mFrameSize;
            CodeScanner.this.mDecoder.decode(data, previewSize.x, previewSize.y, frameSize.x, frameSize.y, CodeScanner.this.mDisplayOrientation, CodeScanner.this.mScannerView.isSquareFrame(), CodeScanner.this.mDecodeCallback);
        }
    }

    private final class ScannerLayoutListener
    implements CodeScannerView.LayoutListener {
        private ScannerLayoutListener() {
        }

        @Override
        public void onLayout(int width, int height) {
            CodeScanner.this.initialize(width, height);
            CodeScanner.this.mScannerView.setLayoutListener(null);
        }
    }
}

