/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.postgresql;

import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.distributed.ExpirationAfterWriteStrategy;
import io.github.bucket4j.distributed.jdbc.CustomColumnProvider;
import io.github.bucket4j.distributed.jdbc.PrimaryKeyMapper;
import io.github.bucket4j.distributed.jdbc.SQLProxyConfiguration;
import io.github.bucket4j.distributed.proxy.ExpiredEntriesCleaner;
import io.github.bucket4j.distributed.proxy.generic.select_for_update.AbstractSelectForUpdateBasedProxyManager;
import io.github.bucket4j.distributed.proxy.generic.select_for_update.LockAndGetResult;
import io.github.bucket4j.distributed.proxy.generic.select_for_update.SelectForUpdateBasedTransaction;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.postgresql.Bucket4jPostgreSQL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.sql.DataSource;

public class PostgreSQLSelectForUpdateBasedProxyManager<K>
extends AbstractSelectForUpdateBasedProxyManager<K>
implements ExpiredEntriesCleaner {
    private final DataSource dataSource;
    private final PrimaryKeyMapper<K> primaryKeyMapper;
    private final String removeSqlQuery;
    private final String updateSqlQuery;
    private final String insertSqlQuery;
    private final String selectSqlQuery;
    private final String clearExpiredSqlQuery;
    private final List<CustomColumnProvider<K>> customColumns = new ArrayList<CustomColumnProvider<K>>();

    public PostgreSQLSelectForUpdateBasedProxyManager(Bucket4jPostgreSQL.PostgreSQLSelectForUpdateBasedProxyManagerBuilder<K> builder) {
        super(builder.getClientSideConfig());
        this.dataSource = builder.getDataSource();
        this.primaryKeyMapper = builder.getPrimaryKeyMapper();
        this.removeSqlQuery = MessageFormat.format("DELETE FROM {0} WHERE {1} = ?", builder.getTableName(), builder.getIdColumnName());
        this.insertSqlQuery = MessageFormat.format("INSERT INTO {0}({1}, {2}) VALUES(?, null) ON CONFLICT({3}) DO NOTHING", builder.getTableName(), builder.getIdColumnName(), builder.getStateColumnName(), builder.getIdColumnName());
        this.selectSqlQuery = MessageFormat.format("SELECT {0} as state FROM {1} WHERE {2} = ? FOR UPDATE", builder.getStateColumnName(), builder.getTableName(), builder.getIdColumnName());
        this.customColumns.addAll(builder.getCustomColumns());
        this.getClientSideConfig().getExpirationAfterWriteStrategy().ifPresent(expiration -> this.customColumns.add(CustomColumnProvider.createExpiresInColumnProvider((String)builder.getExpiresAtColumnName(), (ExpirationAfterWriteStrategy)expiration)));
        if (this.customColumns.isEmpty()) {
            this.updateSqlQuery = MessageFormat.format("UPDATE {0} SET {1}=? WHERE {2}=?", builder.getTableName(), builder.getStateColumnName(), builder.getIdColumnName());
        } else {
            String customPartInUpdate = String.join((CharSequence)",", this.customColumns.stream().map(column -> column.getCustomFieldName() + "=?").toList());
            this.updateSqlQuery = MessageFormat.format("UPDATE {0} SET {1}=?,{2} WHERE {3}=?", builder.getTableName(), builder.getStateColumnName(), customPartInUpdate, builder.getIdColumnName());
        }
        this.clearExpiredSqlQuery = MessageFormat.format("DELETE FROM {0} WHERE\n    {2} < ? AND\n    {1} IN(SELECT {1} FROM {0} WHERE {2} < ? LIMIT ? FOR UPDATE SKIP LOCKED)\n", builder.getTableName(), builder.getIdColumnName(), builder.getExpiresAtColumnName());
    }

    @Deprecated
    public PostgreSQLSelectForUpdateBasedProxyManager(SQLProxyConfiguration<K> configuration) {
        super(configuration.getClientSideConfig());
        this.clearExpiredSqlQuery = null;
        this.dataSource = Objects.requireNonNull(configuration.getDataSource());
        this.primaryKeyMapper = configuration.getPrimaryKeyMapper();
        this.removeSqlQuery = MessageFormat.format("DELETE FROM {0} WHERE {1} = ?", configuration.getTableName(), configuration.getIdName());
        this.updateSqlQuery = MessageFormat.format("UPDATE {0} SET {1}=? WHERE {2}=?", configuration.getTableName(), configuration.getStateName(), configuration.getIdName());
        this.insertSqlQuery = MessageFormat.format("INSERT INTO {0}({1}, {2}) VALUES(?, null) ON CONFLICT({3}) DO NOTHING", configuration.getTableName(), configuration.getIdName(), configuration.getStateName(), configuration.getIdName());
        this.selectSqlQuery = MessageFormat.format("SELECT {0} as state FROM {1} WHERE {2} = ? FOR UPDATE", configuration.getStateName(), configuration.getTableName(), configuration.getIdName());
        if (this.getClientSideConfig().getExpirationAfterWriteStrategy().isPresent()) {
            throw new IllegalArgumentException();
        }
    }

    public boolean isExpireAfterWriteSupported() {
        return true;
    }

    protected SelectForUpdateBasedTransaction allocateTransaction(final K key, Optional<Long> requestTimeoutNanos) {
        Connection connection;
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new BucketExceptions.BucketExecutionException((Throwable)e);
        }
        return new SelectForUpdateBasedTransaction(){

            public void begin(Optional<Long> requestTimeoutNanos) {
                try {
                    connection.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new BucketExceptions.BucketExecutionException((Throwable)e);
                }
            }

            public void rollback() {
                try {
                    connection.rollback();
                }
                catch (SQLException e) {
                    throw new BucketExceptions.BucketExecutionException((Throwable)e);
                }
            }

            public void commit(Optional<Long> requestTimeoutNanos) {
                try {
                    connection.commit();
                }
                catch (SQLException e) {
                    throw new BucketExceptions.BucketExecutionException((Throwable)e);
                }
            }

            /*
             * Enabled aggressive exception aggregation
             */
            public LockAndGetResult tryLockAndGet(Optional<Long> requestTimeoutNanos) {
                try (PreparedStatement selectStatement = connection.prepareStatement(PostgreSQLSelectForUpdateBasedProxyManager.this.selectSqlQuery);){
                    LockAndGetResult lockAndGetResult;
                    block18: {
                        ResultSet rs;
                        block16: {
                            LockAndGetResult lockAndGetResult2;
                            block17: {
                                PostgreSQLSelectForUpdateBasedProxyManager.this.applyTimeout(selectStatement, requestTimeoutNanos);
                                PostgreSQLSelectForUpdateBasedProxyManager.this.primaryKeyMapper.set(selectStatement, 1, key);
                                rs = selectStatement.executeQuery();
                                try {
                                    if (!rs.next()) break block16;
                                    byte[] data = rs.getBytes("state");
                                    lockAndGetResult2 = LockAndGetResult.locked((byte[])data);
                                    if (rs == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (rs != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                rs.close();
                            }
                            return lockAndGetResult2;
                        }
                        lockAndGetResult = LockAndGetResult.notLocked();
                        if (rs == null) break block18;
                        rs.close();
                    }
                    return lockAndGetResult;
                }
                catch (SQLException e) {
                    throw new BucketExceptions.BucketExecutionException((Throwable)e);
                }
            }

            public boolean tryInsertEmptyData(Optional<Long> requestTimeoutNanos) {
                boolean bl;
                block8: {
                    PreparedStatement insertStatement = connection.prepareStatement(PostgreSQLSelectForUpdateBasedProxyManager.this.insertSqlQuery);
                    try {
                        PostgreSQLSelectForUpdateBasedProxyManager.this.applyTimeout(insertStatement, requestTimeoutNanos);
                        PostgreSQLSelectForUpdateBasedProxyManager.this.primaryKeyMapper.set(insertStatement, 1, key);
                        boolean bl2 = bl = insertStatement.executeUpdate() > 0;
                        if (insertStatement == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (insertStatement != null) {
                                try {
                                    insertStatement.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            throw new BucketExceptions.BucketExecutionException((Throwable)e);
                        }
                    }
                    insertStatement.close();
                }
                return bl;
            }

            public void update(byte[] data, RemoteBucketState newState, Optional<Long> requestTimeoutNanos) {
                try (PreparedStatement updateStatement = connection.prepareStatement(PostgreSQLSelectForUpdateBasedProxyManager.this.updateSqlQuery);){
                    PostgreSQLSelectForUpdateBasedProxyManager.this.applyTimeout(updateStatement, requestTimeoutNanos);
                    int i = 0;
                    updateStatement.setBytes(++i, data);
                    for (CustomColumnProvider column : PostgreSQLSelectForUpdateBasedProxyManager.this.customColumns) {
                        column.setCustomField(key, ++i, updateStatement, newState, PostgreSQLSelectForUpdateBasedProxyManager.this.currentTimeNanos());
                    }
                    PostgreSQLSelectForUpdateBasedProxyManager.this.primaryKeyMapper.set(updateStatement, ++i, key);
                    updateStatement.executeUpdate();
                }
                catch (SQLException e) {
                    throw new BucketExceptions.BucketExecutionException((Throwable)e);
                }
            }

            public void release() {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    throw new BucketExceptions.BucketExecutionException((Throwable)e);
                }
            }
        };
    }

    public void removeProxy(K key) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement removeStatement = connection.prepareStatement(this.removeSqlQuery);){
            this.primaryKeyMapper.set(removeStatement, 1, key);
            removeStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new BucketExceptions.BucketExecutionException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int removeExpired(int batchSize) {
        try (Connection connection = this.dataSource.getConnection();){
            int n;
            block14: {
                long currentTimeMillis = System.currentTimeMillis();
                PreparedStatement clearStatement = connection.prepareStatement(this.clearExpiredSqlQuery);
                try {
                    clearStatement.setLong(1, currentTimeMillis);
                    clearStatement.setLong(2, currentTimeMillis);
                    clearStatement.setInt(3, batchSize);
                    n = clearStatement.executeUpdate();
                    if (clearStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (clearStatement != null) {
                        try {
                            clearStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                clearStatement.close();
            }
            return n;
        }
        catch (SQLException e) {
            throw new BucketExceptions.BucketExecutionException((Throwable)e);
        }
    }
}

