/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy.optimization.manual;

import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.proxy.AsyncCommandExecutor;
import io.github.bucket4j.distributed.proxy.CommandExecutor;
import io.github.bucket4j.distributed.proxy.optimization.OptimizationListener;
import io.github.bucket4j.distributed.remote.BucketEntryWrapper;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MultiResult;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.remote.commands.ConsumeIgnoringRateLimitsCommand;
import io.github.bucket4j.distributed.remote.commands.CreateSnapshotCommand;
import io.github.bucket4j.distributed.remote.commands.MultiCommand;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.locks.ReentrantLock;

class ManuallySyncingCommandExecutor
implements CommandExecutor,
AsyncCommandExecutor {
    private static final int ORIGINAL_COMMAND_INDEX = 1;
    private static final int GET_SNAPSHOT_COMMAND_INDEX = 2;
    private final CommandExecutor originalExecutor;
    private final AsyncCommandExecutor originalAsyncExecutor;
    private final OptimizationListener listener;
    private final TimeMeter timeMeter;
    private RemoteBucketState state;
    private long lastSyncTimeNanos;
    private long postponedToConsumeTokens;
    private final ReentrantLock localStateMutationLock = new ReentrantLock();
    private final ReentrantLock remoteExecutionLock = new ReentrantLock();
    private CompletableFuture<?> inProgressSynchronizationFuture;

    ManuallySyncingCommandExecutor(CommandExecutor originalExecutor, OptimizationListener listener, TimeMeter timeMeter) {
        this.originalExecutor = originalExecutor;
        this.originalAsyncExecutor = null;
        this.listener = listener;
        this.timeMeter = timeMeter;
    }

    ManuallySyncingCommandExecutor(AsyncCommandExecutor originalAsyncExecutor, OptimizationListener listener, TimeMeter timeMeter) {
        this.originalExecutor = null;
        this.originalAsyncExecutor = originalAsyncExecutor;
        this.listener = listener;
        this.timeMeter = timeMeter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> CommandResult<T> execute(RemoteCommand<T> command) {
        MultiCommand remoteCommand;
        this.localStateMutationLock.lock();
        try {
            CommandResult<T> localResult = this.tryConsumeLocally(command);
            if (localResult != null) {
                this.listener.incrementSkipCount(1);
                CommandResult<T> commandResult = localResult;
                return commandResult;
            }
            remoteCommand = this.prepareRemoteCommand(command);
        }
        finally {
            this.localStateMutationLock.unlock();
        }
        this.remoteExecutionLock.lock();
        try {
            MultiResult multiResult = this.originalExecutor.execute(remoteCommand).getData();
            this.rememberRemoteCommandResult(multiResult);
            CommandResult<?> commandResult = multiResult.getResults().get(1);
            return commandResult;
        }
        finally {
            this.remoteExecutionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> CompletableFuture<CommandResult<T>> executeAsync(RemoteCommand<T> command) {
        CompletionStage<CommandResult<MultiResult>> resultFuture;
        MultiCommand remoteCommand;
        this.localStateMutationLock.lock();
        try {
            CommandResult<T> result = this.tryConsumeLocally(command);
            if (result != null) {
                this.listener.incrementSkipCount(1);
                CompletableFuture<CommandResult<T>> completableFuture = CompletableFuture.completedFuture(result);
                return completableFuture;
            }
            remoteCommand = this.prepareRemoteCommand(command);
        }
        finally {
            this.localStateMutationLock.unlock();
        }
        this.remoteExecutionLock.lock();
        try {
            resultFuture = this.inProgressSynchronizationFuture == null ? this.originalAsyncExecutor.executeAsync(remoteCommand) : this.inProgressSynchronizationFuture.thenCompose(f -> {
                assert (this.originalAsyncExecutor != null);
                return this.originalAsyncExecutor.executeAsync(remoteCommand);
            });
            this.inProgressSynchronizationFuture = resultFuture;
        }
        finally {
            this.remoteExecutionLock.unlock();
        }
        return ((CompletableFuture)resultFuture).thenApply(remoteResult -> {
            MultiResult multiResult = (MultiResult)remoteResult.getData();
            this.rememberRemoteCommandResult(multiResult);
            return multiResult.getResults().get(1);
        });
    }

    private <T> CommandResult<T> tryConsumeLocally(RemoteCommand<T> command) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        if (this.isNeedToExecuteRemoteImmediately(command, currentTimeNanos)) {
            return null;
        }
        BucketEntryWrapper entry = new BucketEntryWrapper(this.state.copy());
        CommandResult<T> result = command.execute(entry, currentTimeNanos);
        long locallyConsumedTokens = command.getConsumedTokens(result.getData());
        if (locallyConsumedTokens == Long.MAX_VALUE) {
            return null;
        }
        if (!this.isLocalExecutionResultSatisfiesThreshold(locallyConsumedTokens)) {
            return null;
        }
        this.postponedToConsumeTokens += locallyConsumedTokens;
        if (entry.isStateModified()) {
            this.state = entry.get();
        }
        return result;
    }

    private boolean isLocalExecutionResultSatisfiesThreshold(long locallyConsumedTokens) {
        return locallyConsumedTokens != Long.MAX_VALUE && this.postponedToConsumeTokens + locallyConsumedTokens >= 0L;
    }

    private <T> boolean isNeedToExecuteRemoteImmediately(RemoteCommand<T> command, long currentTimeNanos) {
        if (this.state == null) {
            return true;
        }
        if (command.isImmediateSyncRequired(this.postponedToConsumeTokens, currentTimeNanos - this.lastSyncTimeNanos)) {
            return true;
        }
        long commandTokens = command.estimateTokensToConsume();
        return commandTokens == Long.MAX_VALUE || commandTokens + this.postponedToConsumeTokens < 0L;
    }

    private <T> MultiCommand prepareRemoteCommand(RemoteCommand<T> command) {
        ArrayList commands = new ArrayList(3);
        commands.add(new ConsumeIgnoringRateLimitsCommand(this.postponedToConsumeTokens));
        this.postponedToConsumeTokens = 0L;
        commands.add(command);
        commands.add(new CreateSnapshotCommand());
        return new MultiCommand(commands);
    }

    private void rememberRemoteCommandResult(MultiResult multiResult) {
        this.localStateMutationLock.lock();
        try {
            this.lastSyncTimeNanos = this.timeMeter.currentTimeNanos();
            CommandResult<?> snapshotResult = multiResult.getResults().get(2);
            if (snapshotResult.isError()) {
                this.state = null;
                return;
            }
            this.state = (RemoteBucketState)snapshotResult.getData();
            if (this.postponedToConsumeTokens > 0L) {
                this.state.consume(this.postponedToConsumeTokens);
            }
        }
        finally {
            this.localStateMutationLock.unlock();
        }
    }
}

