/*
 * Decompiled with CFR 0.152.
 */
package com.btmatthews.selenium.junit4.runner;

import com.btmatthews.selenium.junit4.runner.SeleniumBrowser;
import com.btmatthews.selenium.junit4.runner.SeleniumFactory;
import com.btmatthews.selenium.junit4.runner.SeleniumServer;
import com.btmatthews.selenium.junit4.runner.SeleniumWebDriver;
import com.btmatthews.selenium.junit4.runner.ServerConfiguration;
import com.btmatthews.selenium.junit4.runner.ServerFactory;
import com.btmatthews.selenium.junit4.runner.WebDriverConfiguration;
import com.btmatthews.selenium.junit4.runner.WebDriverFactory;
import com.btmatthews.selenium.junit4.runner.WrappedDriverConfiguration;
import com.btmatthews.selenium.junit4.runner.WrappedDriverFactory;
import com.thoughtworks.selenium.Selenium;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.junit.rules.TestRule;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumJUnit4ClassRunner
extends Suite {
    public SeleniumJUnit4ClassRunner(Class<?> klass) throws InitializationError {
        super(klass, SeleniumJUnit4ClassRunner.buildRunners(klass));
    }

    private static List<Runner> buildRunners(Class<?> klass) throws InitializationError {
        List<Runner> runners;
        ServerConfiguration seleniumServerConfiguration = klass.getAnnotation(ServerConfiguration.class);
        WebDriverConfiguration webDriverConfiguration = klass.getAnnotation(WebDriverConfiguration.class);
        WrappedDriverConfiguration wrappedDriverConfiguration = klass.getAnnotation(WrappedDriverConfiguration.class);
        if (seleniumServerConfiguration != null) {
            runners = SeleniumJUnit4ClassRunner.buildSeleniumServerRunners(seleniumServerConfiguration, klass);
        } else if (webDriverConfiguration != null) {
            runners = SeleniumJUnit4ClassRunner.buildWebDriverRunners(webDriverConfiguration, klass);
        } else if (wrappedDriverConfiguration != null) {
            runners = SeleniumJUnit4ClassRunner.buildWrappedDriverRunners(wrappedDriverConfiguration, klass);
        } else {
            throw new InitializationError("Annotate test class with either ServerConfiguration, WebDriverConfiguration or WrappedDriverConfiguration");
        }
        return runners;
    }

    private static List<Runner> buildWebDriverRunners(WebDriverConfiguration configuration, Class<?> klass) throws InitializationError {
        ArrayList<Runner> runners = new ArrayList<Runner>();
        try {
            for (Class<? extends WebDriver> webDriverClass : configuration.baseDrivers()) {
                WebDriverFactory factory = new WebDriverFactory(webDriverClass);
                runners.add((Runner)new SeleniumWebDriverJUnit4ClassRunner(factory, klass));
            }
        }
        catch (Exception e) {
            throw new InitializationError((Throwable)e);
        }
        return runners;
    }

    private static List<Runner> buildWrappedDriverRunners(WrappedDriverConfiguration configuration, Class<?> klass) throws InitializationError {
        ArrayList<Runner> runners = new ArrayList<Runner>();
        try {
            for (Class<? extends WebDriver> webDriverClass : configuration.baseDrivers()) {
                WrappedDriverFactory factory = new WrappedDriverFactory(configuration, webDriverClass);
                runners.add((Runner)new SeleniumServerJUnit4ClassRunner(factory, klass));
            }
        }
        catch (Exception e) {
            throw new InitializationError((Throwable)e);
        }
        return runners;
    }

    private static List<Runner> buildSeleniumServerRunners(ServerConfiguration configuration, Class<?> klass) throws InitializationError {
        ArrayList<Runner> runners = new ArrayList<Runner>();
        try {
            for (String browserStartCommand : configuration.browserStartCommands()) {
                ServerFactory factory = new ServerFactory(configuration, browserStartCommand);
                runners.add((Runner)new SeleniumServerJUnit4ClassRunner(factory, klass));
            }
        }
        catch (Exception e) {
            throw new InitializationError((Throwable)e);
        }
        return runners;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SeleniumWebDriverJUnit4ClassRunner
    extends AbstractSeleniumJUnit4ClassRunner<WebDriver, SeleniumWebDriver> {
        public SeleniumWebDriverJUnit4ClassRunner(WebDriverFactory factory, Class<?> klass) throws InitializationError {
            super(factory, SeleniumWebDriver.class, klass);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SeleniumServerJUnit4ClassRunner
    extends AbstractSeleniumJUnit4ClassRunner<Selenium, SeleniumServer> {
        public SeleniumServerJUnit4ClassRunner(SeleniumFactory<Selenium> factory, Class<?> klass) throws InitializationError {
            super(factory, SeleniumServer.class, klass);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractSeleniumJUnit4ClassRunner<T, A extends Annotation>
    extends BlockJUnit4ClassRunner {
        private T selenium;
        private SeleniumFactory<T> seleniumFactory;
        private Class<A> annotationType;

        public AbstractSeleniumJUnit4ClassRunner(SeleniumFactory<T> factory, Class<A> type, Class<?> klass) throws InitializationError {
            super(klass);
            this.seleniumFactory = factory;
            this.annotationType = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(RunNotifier notifier) {
            try {
                this.selenium = this.seleniumFactory.create();
                this.seleniumFactory.start(this.selenium);
                try {
                    super.run(notifier);
                }
                finally {
                    this.seleniumFactory.stop(this.selenium);
                }
            }
            catch (Throwable e) {
                Failure failure = new Failure(this.getDescription(), e);
                notifier.fireTestFailure(failure);
            }
            finally {
                this.selenium = null;
            }
        }

        protected Object createTest() throws Exception {
            Object test = super.createTest();
            TestClass testClass = this.getTestClass();
            String browser = this.seleniumFactory.getBrowser();
            List fields = testClass.getAnnotatedFields(this.annotationType);
            for (FrameworkField field : fields) {
                FieldUtils.writeField((Field)field.getField(), (Object)test, this.selenium, (boolean)true);
            }
            fields = testClass.getAnnotatedFields(SeleniumBrowser.class);
            for (FrameworkField field : fields) {
                FieldUtils.writeField((Field)field.getField(), (Object)test, (Object)browser, (boolean)true);
            }
            List rules = this.getTestRules(test);
            for (TestRule rule : rules) {
                Field[] ruleFields;
                for (Field ruleField : ruleFields = rule.getClass().getDeclaredFields()) {
                    if (ruleField.getAnnotation(this.annotationType) != null) {
                        FieldUtils.writeField((Field)ruleField, (Object)rule, this.selenium, (boolean)true);
                        continue;
                    }
                    if (ruleField.getAnnotation(SeleniumBrowser.class) == null) continue;
                    FieldUtils.writeField((Field)ruleField, (Object)rule, (Object)browser, (boolean)true);
                }
            }
            return test;
        }
    }
}

