/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.utils;

import com.bstek.uflo.command.CommandService;
import com.bstek.uflo.command.impl.AcquireDbidCommand;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.StaleStateException;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class IDGenerator
implements ApplicationContextAware {
    private static Log log = LogFactory.getLog(IDGenerator.class);
    private CommandService commandService;
    private static IDGenerator generator;
    private static Random random;
    private long nextId;
    private long lastId = -1L;
    private int blockSize = 5000;
    private int maxAttempts = 5;

    public synchronized long nextId() {
        if (this.lastId < this.nextId) {
            for (int attempts = this.maxAttempts; attempts > 0; --attempts) {
                try {
                    AcquireDbidCommand command = new AcquireDbidCommand(this.blockSize);
                    this.nextId = this.commandService.executeCommandInNewTransaction(command);
                    this.lastId = this.nextId + (long)this.blockSize - 1L;
                    break;
                }
                catch (StaleStateException e) {
                    if (--attempts == 0) {
                        throw new IllegalStateException("couldn't acquire block of ids, tried " + this.maxAttempts + " times");
                    }
                    int millis = 20 + random.nextInt(200);
                    log.debug((Object)("optimistic locking failure while trying to acquire id block.  retrying in " + millis + " millis"));
                    try {
                        Thread.sleep(millis);
                    }
                    catch (InterruptedException e1) {
                        log.debug((Object)"waiting after id block locking failure got interrupted");
                    }
                    continue;
                }
            }
        }
        return this.nextId++;
    }

    public static IDGenerator getInstance() {
        return generator;
    }

    public void setCommandService(CommandService commandService) {
        this.commandService = commandService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        generator = this;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    static {
        random = new Random();
    }
}

