/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.utils;

import com.bstek.uflo.env.EnvironmentProvider;
import com.bstek.uflo.service.CacheService;
import com.bstek.uflo.service.DefaultMemoryCacheService;
import com.bstek.uflo.utils.Splash;
import java.util.Collection;
import org.hibernate.SessionFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.PlatformTransactionManager;

public class EnvironmentUtils
implements ApplicationContextAware {
    private EnvironmentProvider provider;
    private static EnvironmentUtils environment;
    private ApplicationContext applicationContext;
    private CacheService cacheService;

    public static EnvironmentUtils getEnvironment() {
        return environment;
    }

    public SessionFactory getSessionFactory() {
        return this.provider.getSessionFactory();
    }

    public PlatformTransactionManager getPlatformTransactionManager() {
        return this.provider.getPlatformTransactionManager();
    }

    public CacheService getCache() {
        return this.cacheService;
    }

    public String getLoginUser() {
        return this.provider.getLoginUser();
    }

    public String getCategoryId() {
        return this.provider.getCategoryId();
    }

    public EnvironmentProvider getEnvironmentProvider() {
        return this.provider;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        Collection providers = applicationContext.getBeansOfType(EnvironmentProvider.class).values();
        if (providers.size() == 0) {
            throw new RuntimeException("You must be implementation " + EnvironmentProvider.class.getName() + " interface when use uflo!");
        }
        this.provider = (EnvironmentProvider)providers.iterator().next();
        Collection cacheServices = applicationContext.getBeansOfType(CacheService.class).values();
        this.cacheService = cacheServices.size() > 0 ? (CacheService)cacheServices.iterator().next() : new DefaultMemoryCacheService();
        environment = this;
        new Splash().print();
    }
}

