/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.service.impl;

import com.bstek.uflo.env.TaskDueDefinitionProvider;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.model.task.Task;
import com.bstek.uflo.model.task.reminder.ReminderType;
import com.bstek.uflo.model.task.reminder.TaskReminder;
import com.bstek.uflo.process.handler.ReminderHandler;
import com.bstek.uflo.process.node.TaskNode;
import com.bstek.uflo.process.node.calendar.MultipleCalendar;
import com.bstek.uflo.process.node.reminder.CalendarInfo;
import com.bstek.uflo.process.node.reminder.CalendarProvider;
import com.bstek.uflo.process.node.reminder.DueDefinition;
import com.bstek.uflo.process.node.reminder.PeriodReminder;
import com.bstek.uflo.process.node.reminder.Reminder;
import com.bstek.uflo.service.ProcessService;
import com.bstek.uflo.service.SchedulerService;
import com.bstek.uflo.service.TaskService;
import com.bstek.uflo.service.impl.job.ReminderJob;
import com.bstek.uflo.service.impl.job.ReminderJobDetail;
import com.bstek.uflo.service.impl.job.ScanReminderJob;
import com.bstek.uflo.service.impl.job.ScanReminderJobDetail;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.calendar.BaseCalendar;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.quartz.simpl.SimpleThreadPool;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SchedulerServiceImpl
implements SchedulerService,
ApplicationContextAware {
    private static final Logger log = Logger.getLogger(SchedulerServiceImpl.class.getName());
    private static final String JOB_NAME_PREFIX = "reminderJob";
    private static final String JOB_GROUP_PREFIX = "remindergroup";
    private static final String REMINDER_CALENDAR_PREFIX = "reminderCalendar";
    private static final String SCAN_REMINDER_CRON = "0/40 * * * * ?";
    private Scheduler scheduler;
    private TaskService taskService;
    private ProcessService processService;
    private int threadCount;
    private ApplicationContext applicationContext;
    private TaskDueDefinitionProvider provider;
    private String makeSchedulerThreadDaemon;
    private boolean enableScanReminderJob;
    private List<Long> reminderTaskList = new ArrayList<Long>();

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public void addReminderJob(TaskReminder reminder, ProcessInstance processInstance, Task task) {
        JobKey jobKey = new JobKey(JOB_NAME_PREFIX + reminder.getId(), JOB_GROUP_PREFIX);
        try {
            if (this.scheduler.checkExists(jobKey)) {
                return;
            }
            SimpleTriggerImpl trigger = null;
            if (reminder.getType().equals((Object)ReminderType.Once)) {
                SimpleTriggerImpl simpleTrigger = new SimpleTriggerImpl();
                simpleTrigger.setRepeatCount(0);
                trigger = simpleTrigger;
                long executeTime = reminder.getStartDate().getTime() + 10000L;
                long now = new Date().getTime();
                if (executeTime <= now) {
                    return;
                }
            } else {
                CronTriggerImpl cronTrigger = new CronTriggerImpl();
                cronTrigger.setCronExpression(reminder.getCron());
                trigger = cronTrigger;
            }
            trigger.setName("trigger_" + reminder.getId());
            trigger.setStartTime(reminder.getStartDate());
            ReminderJobDetail jobDetail = new ReminderJobDetail();
            jobDetail.setJobClass(ReminderJob.class);
            ReminderHandler handler = (ReminderHandler)this.applicationContext.getBean(reminder.getReminderHandlerBean());
            jobDetail.setReminderHandlerBean(handler);
            if (task == null) {
                task = this.taskService.getTask(reminder.getTaskId());
            }
            jobDetail.setTask(task);
            jobDetail.setProcessInstance(this.processService.getProcessInstanceById(task.getProcessInstanceId()));
            jobDetail.setKey(jobKey);
            Calendar calendar = this.getCalendar(reminder, processInstance, task);
            if (calendar != null) {
                String calendarName = REMINDER_CALENDAR_PREFIX + reminder.getId();
                this.scheduler.addCalendar(calendarName, calendar, false, false);
                trigger.setCalendarName(calendarName);
            }
            this.scheduler.scheduleJob((JobDetail)jobDetail, (Trigger)trigger);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeReminderJob(Task task) {
        List<TaskReminder> reminders = this.taskService.getTaskReminders(task.getId());
        for (TaskReminder reminder : reminders) {
            try {
                this.scheduler.deleteJob(new JobKey(JOB_NAME_PREFIX + reminder.getId(), JOB_GROUP_PREFIX));
            }
            catch (SchedulerException e) {
                throw new RuntimeException(e);
            }
            String calendarId = REMINDER_CALENDAR_PREFIX + reminder.getId();
            try {
                this.scheduler.deleteCalendar(calendarId);
            }
            catch (SchedulerException e) {
                log.warning(e.getMessage());
            }
            this.taskService.deleteTaskReminder(reminder.getId());
            this.reminderTaskList.remove(reminder.getId());
        }
    }

    @Override
    public void deleteJob(long reminderId) {
        try {
            this.scheduler.deleteJob(new JobKey(JOB_NAME_PREFIX + reminderId, JOB_GROUP_PREFIX));
            String calendarId = REMINDER_CALENDAR_PREFIX + reminderId;
            this.scheduler.deleteCalendar(calendarId);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void resetScheduer() {
        try {
            this.reminderTaskList.clear();
            if (this.scheduler != null && !this.scheduler.isShutdown()) {
                this.scheduler.shutdown(false);
            }
            log.info("Current uflo job instance scheduler is starting...");
            this.scheduler = this.newScheduler();
            if (this.scheduler.isInStandbyMode()) {
                this.scheduler.start();
            }
            this.initTaskReminders();
            log.info("Uflo scheduler is started successfully...");
        }
        catch (SchedulerException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Scheduler newScheduler() throws SchedulerException {
        StdSchedulerFactory factory = new StdSchedulerFactory();
        Properties mergedProps = new Properties();
        mergedProps.setProperty("org.quartz.threadPool.class", SimpleThreadPool.class.getName());
        mergedProps.setProperty("org.quartz.scheduler.instanceName", "UFLOScheduler");
        mergedProps.setProperty("org.quartz.scheduler.instanceId", "UFLOScheduler");
        mergedProps.setProperty("org.quartz.scheduler.makeSchedulerThreadDaemon", this.makeSchedulerThreadDaemon);
        mergedProps.setProperty("org.quartz.threadPool.threadCount", Integer.toString(this.threadCount));
        factory.initialize(mergedProps);
        Scheduler newScheduler = factory.getScheduler();
        return newScheduler;
    }

    private void initTaskReminders() {
        List<TaskReminder> reminders = this.taskService.getAllTaskReminders();
        for (TaskReminder reminder : reminders) {
            this.reminderTaskList.add(reminder.getId());
            this.addReminderJob(reminder, null, null);
        }
        if (this.enableScanReminderJob) {
            this.initScanReminderJob();
        }
    }

    private void initScanReminderJob() {
        CronTriggerImpl trigger = new CronTriggerImpl();
        trigger.setName("UfloScanReminderTrigger");
        trigger.setKey(new TriggerKey("UfloScanReminderTrigger"));
        try {
            trigger.setCronExpression(SCAN_REMINDER_CRON);
            ScanReminderJob job = new ScanReminderJob();
            ScanReminderJobDetail detail = new ScanReminderJobDetail();
            detail.setSchedulerService(this);
            detail.setTaskService(this.taskService);
            detail.setReminderTaskList(this.reminderTaskList);
            detail.setJobClass(job.getClass());
            detail.setKey(new JobKey("UfloScanReminderJob"));
            this.scheduler.scheduleJob((JobDetail)detail, (Trigger)trigger);
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    private Calendar getCalendar(TaskReminder taskReminder, ProcessInstance processInstance, Task task) {
        DueDefinition dueDefinition = null;
        Reminder reminder = null;
        if (this.provider != null) {
            if (task == null) {
                long taskId = taskReminder.getTaskId();
                task = this.taskService.getTask(taskId);
            }
            if (processInstance == null) {
                processInstance = this.processService.getProcessInstanceById(task.getProcessInstanceId());
            }
            if ((dueDefinition = this.provider.getDueDefinition(task, processInstance)) != null) {
                reminder = dueDefinition.getReminder();
            }
        }
        if (dueDefinition == null) {
            long processId = taskReminder.getProcessId();
            String taskNodeName = taskReminder.getTaskNodeName();
            TaskNode node = (TaskNode)this.processService.getProcessById(processId).getNode(taskNodeName);
            dueDefinition = node.getDueDefinition();
            if (dueDefinition != null) {
                reminder = dueDefinition.getReminder();
            }
        }
        if (reminder == null || !(reminder instanceof PeriodReminder)) {
            return null;
        }
        List<CalendarInfo> infos = ((PeriodReminder)reminder).getCalendarInfos();
        if (infos == null) {
            return null;
        }
        return this.buildCalendar(infos);
    }

    @Override
    public Calendar buildCalendar(List<CalendarInfo> infos) {
        MultipleCalendar mulCalendar = null;
        Collection providers = this.applicationContext.getBeansOfType(CalendarProvider.class).values();
        for (CalendarInfo info : infos) {
            for (CalendarProvider provider : providers) {
                Calendar calendar = provider.getCalendar(info.getId());
                if (calendar == null) continue;
                if (mulCalendar == null) {
                    mulCalendar = new MultipleCalendar();
                }
                mulCalendar.addCalendar((BaseCalendar)calendar);
            }
        }
        return mulCalendar;
    }

    public void setMakeSchedulerThreadDaemon(String makeSchedulerThreadDaemon) {
        this.makeSchedulerThreadDaemon = makeSchedulerThreadDaemon;
    }

    public void setEnableScanReminderJob(boolean enableScanReminderJob) {
        this.enableScanReminderJob = enableScanReminderJob;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        Collection colls = applicationContext.getBeansOfType(TaskDueDefinitionProvider.class).values();
        if (colls.size() > 0) {
            this.provider = (TaskDueDefinitionProvider)colls.iterator().next();
        }
    }

    public void destroy() {
        try {
            if (this.scheduler != null && !this.scheduler.isShutdown()) {
                this.scheduler.shutdown(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }
}

