/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.service.impl;

import com.bstek.uflo.service.RestService;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestServiceImpl
implements RestService {
    private String baseUrl;
    private HttpHeaders headers;
    private RestTemplate template = new RestTemplate();
    private List<HttpMessageConverter<?>> converters;

    public RestServiceImpl(String username, String password) {
        this.headers = new HttpHeaders();
        this.headers.setContentType(MediaType.APPLICATION_XML);
        if (StringUtils.isEmpty((String)username) || StringUtils.isEmpty((String)password)) {
            return;
        }
        this.headers.add("uflo.access.username", username);
        this.headers.add("uflo.access.password", password);
    }

    @Override
    public <T> ResponseEntity<T> post(String uri, Object obj, Class<T> responseClazz) {
        if (obj == null) {
            obj = "blank";
        }
        HttpEntity entity = null;
        entity = this.headers != null ? new HttpEntity(obj, (MultiValueMap)this.headers) : new HttpEntity(obj);
        return this.template.postForEntity(this.baseUrl + uri, (Object)entity, responseClazz, new Object[0]);
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public List<HttpMessageConverter<?>> getConverters() {
        return this.converters;
    }

    public void setConverters(List<HttpMessageConverter<?>> converters) {
        this.converters = converters;
        this.template.setMessageConverters(converters);
    }
}

