/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.service.impl;

import com.bstek.uflo.command.CommandService;
import com.bstek.uflo.command.impl.AddCountersignCommand;
import com.bstek.uflo.command.impl.BatchCompleteTasksCommand;
import com.bstek.uflo.command.impl.BatchStartAndCompleteTasksCommand;
import com.bstek.uflo.command.impl.BatchStartTasksCommand;
import com.bstek.uflo.command.impl.CanWithdrawDecisionCommand;
import com.bstek.uflo.command.impl.CancelTaskCommand;
import com.bstek.uflo.command.impl.ChangeTaskAssigneeCommand;
import com.bstek.uflo.command.impl.ChangeTaskPriorityCommand;
import com.bstek.uflo.command.impl.ChangeTaskProgressCommand;
import com.bstek.uflo.command.impl.ClaimTaskCommand;
import com.bstek.uflo.command.impl.CompleteTaskCommand;
import com.bstek.uflo.command.impl.DeleteCountersignCommand;
import com.bstek.uflo.command.impl.DeleteTaskByNodeCommand;
import com.bstek.uflo.command.impl.DeleteTaskCommand;
import com.bstek.uflo.command.impl.DeleteTaskReminderCommand;
import com.bstek.uflo.command.impl.ForwardTaskCommand;
import com.bstek.uflo.command.impl.GetAvaliableAppointAssigneeTaskNodes;
import com.bstek.uflo.command.impl.GetJumpAvaliableTaskNodesCommand;
import com.bstek.uflo.command.impl.GetTaskAppointorCommand;
import com.bstek.uflo.command.impl.GetTaskCommand;
import com.bstek.uflo.command.impl.GetTaskNodeAssigneesCommand;
import com.bstek.uflo.command.impl.GetTaskParticipatorsCommand;
import com.bstek.uflo.command.impl.GetTaskReminderCommand;
import com.bstek.uflo.command.impl.ReleaseTaskCommand;
import com.bstek.uflo.command.impl.ResumeTaskCommand;
import com.bstek.uflo.command.impl.RollbackTaskCommand;
import com.bstek.uflo.command.impl.SaveTaskAppointorCommand;
import com.bstek.uflo.command.impl.StartTaskCommand;
import com.bstek.uflo.command.impl.SuspendTaskCommand;
import com.bstek.uflo.command.impl.WithdrawTaskCommand;
import com.bstek.uflo.command.impl.jump.JumpNode;
import com.bstek.uflo.model.HistoryActivity;
import com.bstek.uflo.model.ProcessDefinition;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.model.task.Task;
import com.bstek.uflo.model.task.TaskAppointor;
import com.bstek.uflo.model.task.TaskParticipator;
import com.bstek.uflo.model.task.TaskState;
import com.bstek.uflo.model.task.reminder.TaskReminder;
import com.bstek.uflo.process.node.TaskNode;
import com.bstek.uflo.process.node.UserData;
import com.bstek.uflo.query.TaskQuery;
import com.bstek.uflo.query.impl.TaskQueryImpl;
import com.bstek.uflo.service.HistoryService;
import com.bstek.uflo.service.ProcessService;
import com.bstek.uflo.service.TaskOpinion;
import com.bstek.uflo.service.TaskService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DefaultTaskService
implements TaskService {
    private CommandService commandService;
    private HistoryService historyService;
    private ProcessService processService;

    @Override
    public void setProgress(int progress, long taskId) {
        Task task = this.getTask(taskId);
        this.commandService.executeCommand(new ChangeTaskProgressCommand(task, progress));
    }

    @Override
    public void setPriority(String priority, long taskId) {
        Task task = this.getTask(taskId);
        this.commandService.executeCommand(new ChangeTaskPriorityCommand(task, priority));
    }

    @Override
    public Task addCountersign(long taskId, String username) {
        Task task = this.getTask(taskId);
        return this.commandService.executeCommand(new AddCountersignCommand(task, username));
    }

    @Override
    public void deleteCountersign(long taskId) {
        Task task = this.getTask(taskId);
        this.commandService.executeCommand(new DeleteCountersignCommand(task));
    }

    @Override
    public void deleteTask(long taskId) {
        Task task = this.getTask(taskId);
        this.commandService.executeCommand(new DeleteTaskCommand(task));
    }

    @Override
    public void deleteTaskByNode(long processInstanceId, String nodeName) {
        this.commandService.executeCommand(new DeleteTaskByNodeCommand(processInstanceId, nodeName));
    }

    @Override
    public void cancelTask(long taskId) {
        Task task = this.getTask(taskId);
        this.commandService.executeCommand(new CancelTaskCommand(task, null));
    }

    @Override
    public void cancelTask(long taskId, TaskOpinion opinion) {
        Task task = this.getTask(taskId);
        this.commandService.executeCommand(new CancelTaskCommand(task, opinion));
    }

    @Override
    public List<JumpNode> getAvaliableForwardTaskNodes(long taskId) {
        Task task = this.getTask(taskId);
        return this.getAvaliableForwardTaskNodes(task);
    }

    public List<JumpNode> getAvaliableForwardTaskNodes(Task task) {
        return this.commandService.executeCommand(new GetJumpAvaliableTaskNodesCommand(task));
    }

    @Override
    public void saveTaskAppointor(long taskId, String assignee, String taskNodeName) {
        this.saveTaskAppointor(taskId, new String[]{assignee}, taskNodeName);
    }

    @Override
    public void saveTaskAppointor(long taskId, String[] assignees, String taskNodeName) {
        Task task = this.getTask(taskId);
        this.commandService.executeCommand(new SaveTaskAppointorCommand(task, taskNodeName, assignees));
    }

    @Override
    public List<String> getAvaliableAppointAssigneeTaskNodes(long taskId) {
        Task task = this.getTask(taskId);
        return this.commandService.executeCommand(new GetAvaliableAppointAssigneeTaskNodes(task));
    }

    @Override
    public List<String> getTaskNodeAssignees(long taskId, String taskNodeName) {
        return this.commandService.executeCommand(new GetTaskNodeAssigneesCommand(taskId, taskNodeName));
    }

    @Override
    public List<JumpNode> getAvaliableRollbackTaskNodes(Task task) {
        ProcessInstance pi = this.processService.getProcessInstanceById(task.getProcessInstanceId());
        List<JumpNode> allNodes = this.getAvaliableForwardTaskNodes(task);
        List<HistoryActivity> hisActivities = this.historyService.getHistoryActivitysByProcesssInstanceId(pi.getRootId());
        ArrayList<JumpNode> result = new ArrayList<JumpNode>();
        block0: for (JumpNode node : allNodes) {
            for (HistoryActivity activity : hisActivities) {
                if (!node.getName().equals(activity.getNodeName())) continue;
                result.add(node);
                continue block0;
            }
        }
        return result;
    }

    @Override
    public List<JumpNode> getAvaliableRollbackTaskNodes(long taskId) {
        Task task = this.getTask(taskId);
        return this.getAvaliableRollbackTaskNodes(task);
    }

    @Override
    public void rollback(long taskId, String targetNodeName) {
        this.forward(taskId, targetNodeName);
    }

    @Override
    public void rollback(long taskId, String targetNodeName, Map<String, Object> variables) {
        Task task = this.getTask(taskId);
        this.rollback(task, targetNodeName, variables, null);
    }

    @Override
    public void rollback(long taskId, String targetNodeName, Map<String, Object> variables, TaskOpinion opinion) {
        Task task = this.getTask(taskId);
        this.rollback(task, targetNodeName, variables, opinion);
    }

    @Override
    public void rollback(Task task, String targetNodeName, Map<String, Object> variables, TaskOpinion opinion) {
        this.commandService.executeCommand(new RollbackTaskCommand(task, targetNodeName, variables, opinion));
    }

    @Override
    public void complete(long taskId, String flowName) {
        this.complete(taskId, flowName, null, null);
    }

    @Override
    public void complete(long taskId, String flowName, TaskOpinion opinion) {
        this.complete(taskId, flowName, null, opinion);
    }

    @Override
    public void batchComplete(List<Long> taskIds, Map<String, Object> variables) {
        this.commandService.executeCommand(new BatchCompleteTasksCommand(taskIds, variables, null));
    }

    @Override
    public void batchComplete(List<Long> taskIds, Map<String, Object> variables, TaskOpinion opinion) {
        this.commandService.executeCommand(new BatchCompleteTasksCommand(taskIds, variables, opinion));
    }

    @Override
    public void batchStartAndComplete(List<Long> taskIds, Map<String, Object> variables, TaskOpinion opinion) {
        this.commandService.executeCommand(new BatchStartAndCompleteTasksCommand(taskIds, variables, opinion));
    }

    @Override
    public void batchStart(List<Long> taskIds) {
        this.commandService.executeCommand(new BatchStartTasksCommand(taskIds));
    }

    @Override
    public void batchStartAndComplete(List<Long> taskIds, Map<String, Object> variables) {
        this.commandService.executeCommand(new BatchStartAndCompleteTasksCommand(taskIds, variables, null));
    }

    @Override
    public void complete(long taskId, String flowName, Map<String, Object> variables) {
        Task task = this.getTask(taskId);
        this.commandService.executeCommand(new CompleteTaskCommand(task, flowName, null, variables));
    }

    @Override
    public void complete(long taskId, String flowName, Map<String, Object> variables, TaskOpinion opinion) {
        Task task = this.getTask(taskId);
        this.commandService.executeCommand(new CompleteTaskCommand(task, flowName, opinion, variables));
    }

    @Override
    public void complete(long taskId) {
        this.complete(taskId, null, null, null);
    }

    @Override
    public void complete(long taskId, TaskOpinion opinion) {
        this.complete(taskId, null, null, opinion);
    }

    @Override
    public void complete(long taskId, Map<String, Object> variables) {
        this.complete(taskId, null, variables, null);
    }

    @Override
    public void complete(long taskId, Map<String, Object> variables, TaskOpinion opinion) {
        this.complete(taskId, null, variables, opinion);
    }

    @Override
    public void forward(long taskId, String targetNodeName) {
        this.forward(taskId, targetNodeName, null, null);
    }

    @Override
    public void forward(long taskId, String targetNodeName, TaskOpinion opinion) {
        this.forward(taskId, targetNodeName, null, opinion);
    }

    @Override
    public void forward(long taskId, String targetNodeName, Map<String, Object> variables) {
        this.forward(taskId, targetNodeName, variables, null);
    }

    @Override
    public void forward(long taskId, String targetNodeName, Map<String, Object> variables, TaskOpinion opinion) {
        Task task = this.getTask(taskId);
        this.forward(task, targetNodeName, variables, opinion, TaskState.Forwarded);
    }

    @Override
    public void forward(Task task, String targetNodeName, Map<String, Object> variables, TaskOpinion opinion) {
        this.forward(task, targetNodeName, variables, opinion, TaskState.Forwarded);
    }

    @Override
    public void forward(Task task, String targetNodeName, Map<String, Object> variables, TaskOpinion opinion, TaskState state) {
        this.commandService.executeCommand(new ForwardTaskCommand(task, targetNodeName, variables, opinion, state));
    }

    @Override
    public void withdraw(long taskId) {
        this.withdraw(taskId, null, null);
    }

    @Override
    public void withdraw(long taskId, TaskOpinion opinion) {
        this.withdraw(taskId, null, opinion);
    }

    @Override
    public void withdraw(long taskId, Map<String, Object> variables) {
        this.withdraw(taskId, variables, null);
    }

    @Override
    public void withdraw(long taskId, Map<String, Object> variables, TaskOpinion opinion) {
        Task task = this.getTask(taskId);
        if (task.getState().equals((Object)TaskState.InProgress)) {
            throw new IllegalStateException("Task " + task.getTaskName() + " state is InProgress,can not be withdraw.");
        }
        this.commandService.executeCommand(new WithdrawTaskCommand(task, variables, opinion));
    }

    @Override
    public boolean canWithdraw(long taskId) {
        Task task = this.getTask(taskId);
        return this.canWithdraw(task);
    }

    @Override
    public boolean canWithdraw(Task task) {
        if (task.getState().equals((Object)TaskState.InProgress)) {
            return false;
        }
        return this.commandService.executeCommand(new CanWithdrawDecisionCommand(task));
    }

    @Override
    public Task getTask(long taskId) {
        return this.commandService.executeCommand(new GetTaskCommand(taskId));
    }

    @Override
    public void claim(long taskId, String username) {
        Task task = this.getTask(taskId);
        this.commandService.executeCommand(new ClaimTaskCommand(task, username));
    }

    @Override
    public void release(long taskId) {
        Task task = this.getTask(taskId);
        this.commandService.executeCommand(new ReleaseTaskCommand(task));
    }

    @Override
    public void start(long taskId) {
        Task task = this.getTask(taskId);
        this.commandService.executeCommand(new StartTaskCommand(task));
    }

    @Override
    public void suspend(long taskId) {
        Task task = this.getTask(taskId);
        this.commandService.executeCommand(new SuspendTaskCommand(task));
    }

    @Override
    public void resume(long taskId) {
        Task task = this.getTask(taskId);
        this.commandService.executeCommand(new ResumeTaskCommand(task));
    }

    @Override
    public List<TaskAppointor> getTaskAppointors(String taskNodeName, long processInstanceId) {
        return this.commandService.executeCommand(new GetTaskAppointorCommand(taskNodeName, processInstanceId));
    }

    @Override
    public void changeTaskAssignee(long taskId, String username) {
        this.commandService.executeCommand(new ChangeTaskAssigneeCommand(taskId, username));
    }

    @Override
    public String getUserData(Task task, String key) {
        return this.getUserData(task.getProcessId(), task.getTaskName(), key);
    }

    @Override
    public String getUserData(long processId, String taskNodeName, String key) {
        ProcessDefinition process = this.processService.getProcessById(processId);
        TaskNode node = (TaskNode)process.getNode(taskNodeName);
        if (node.getUserData() == null) {
            return null;
        }
        for (UserData data : node.getUserData()) {
            if (!data.getKey().equals(key)) continue;
            return data.getValue();
        }
        return null;
    }

    @Override
    public TaskQuery createTaskQuery() {
        return new TaskQueryImpl(this.commandService);
    }

    @Override
    public List<TaskReminder> getAllTaskReminders() {
        return this.commandService.executeCommand(new GetTaskReminderCommand(0L));
    }

    @Override
    public List<TaskParticipator> getTaskParticipators(long taskId) {
        return this.commandService.executeCommand(new GetTaskParticipatorsCommand(taskId));
    }

    @Override
    public List<TaskReminder> getTaskReminders(long taskId) {
        return this.commandService.executeCommand(new GetTaskReminderCommand(taskId));
    }

    @Override
    public void deleteTaskReminder(long taskReminderId) {
        this.commandService.executeCommand(new DeleteTaskReminderCommand(taskReminderId));
    }

    public void setCommandService(CommandService commandService) {
        this.commandService = commandService;
    }

    public HistoryService getHistoryService() {
        return this.historyService;
    }

    public void setHistoryService(HistoryService historyService) {
        this.historyService = historyService;
    }

    public ProcessService getProcessService() {
        return this.processService;
    }

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }
}

