/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.service.impl;

import com.bstek.uflo.command.CommandService;
import com.bstek.uflo.command.impl.DeleteProcessDefinitionCommand;
import com.bstek.uflo.command.impl.DeleteProcessInstanceCommand;
import com.bstek.uflo.command.impl.DeleteProcessVariableCommand;
import com.bstek.uflo.command.impl.GetExpressionValueCommand;
import com.bstek.uflo.command.impl.GetProcessByKeyCommand;
import com.bstek.uflo.command.impl.GetProcessCommand;
import com.bstek.uflo.command.impl.GetProcessInstanceCommand;
import com.bstek.uflo.command.impl.GetProcessInstanceVariableCommand;
import com.bstek.uflo.command.impl.SaveProcessInstanceVariablesCommand;
import com.bstek.uflo.command.impl.StartProcessInstanceCommand;
import com.bstek.uflo.deploy.ProcessDeployer;
import com.bstek.uflo.model.ProcessDefinition;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.model.variable.Variable;
import com.bstek.uflo.query.ProcessInstanceQuery;
import com.bstek.uflo.query.ProcessQuery;
import com.bstek.uflo.query.ProcessVariableQuery;
import com.bstek.uflo.query.impl.ProcessInstanceQueryImpl;
import com.bstek.uflo.query.impl.ProcessQueryImpl;
import com.bstek.uflo.query.impl.ProcessVariableQueryImpl;
import com.bstek.uflo.service.CacheService;
import com.bstek.uflo.service.ProcessInterceptor;
import com.bstek.uflo.service.ProcessService;
import com.bstek.uflo.service.StartProcessInfo;
import com.bstek.uflo.utils.EnvironmentUtils;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultProcessService
implements ProcessService,
ApplicationContextAware {
    private Collection<ProcessInterceptor> processInterceptors;
    private ProcessDeployer processDeployer;
    private CommandService commandService;

    @Override
    public synchronized ProcessDefinition getProcessById(long processId) {
        CacheService cache = EnvironmentUtils.getEnvironment().getCache();
        if (cache.containsProcessDefinition(processId)) {
            return cache.getProcessDefinition(processId);
        }
        ProcessDefinition process = this.commandService.executeCommand(new GetProcessCommand(processId, null, 0, null));
        cache.putProcessDefinition(process.getId(), process);
        return process;
    }

    @Override
    public void deleteProcessVariable(String key, long processInstanceId) {
        this.commandService.executeCommand(new DeleteProcessVariableCommand(key, processInstanceId));
    }

    @Override
    public ProcessDefinition getProcessByKey(String key) {
        CacheService cache = EnvironmentUtils.getEnvironment().getCache();
        for (ProcessDefinition pd : cache.loadAllProcessDefinitions()) {
            if (pd.getKey() == null || !pd.getKey().equals(key)) continue;
            return pd;
        }
        ProcessDefinition process = this.commandService.executeCommand(new GetProcessByKeyCommand(key));
        if (process != null) {
            cache.putProcessDefinition(process.getId(), process);
        }
        return process;
    }

    @Override
    public ProcessDefinition getProcessByName(String processName) {
        return this.commandService.executeCommand(new GetProcessCommand(0L, processName, 0, null));
    }

    @Override
    public ProcessDefinition getProcessByName(String processName, String categoryId) {
        return this.commandService.executeCommand(new GetProcessCommand(0L, processName, 0, categoryId));
    }

    @Override
    public synchronized ProcessDefinition getProcessByName(String processName, int version) {
        CacheService cache = EnvironmentUtils.getEnvironment().getCache();
        ProcessDefinition target = null;
        for (ProcessDefinition p : cache.loadAllProcessDefinitions()) {
            if (!p.getName().equals(processName) || p.getVersion() != version) continue;
            target = p;
            break;
        }
        if (target != null) {
            return target;
        }
        ProcessDefinition process = this.commandService.executeCommand(new GetProcessCommand(0L, processName, version, null));
        cache.putProcessDefinition(process.getId(), process);
        return process;
    }

    @Override
    public ProcessInstance startProcessByKey(String key, StartProcessInfo startProcessInfo) {
        ProcessDefinition process = this.getProcessByKey(key);
        if (process == null) {
            throw new IllegalArgumentException("Process definition [" + key + "] was not exist!");
        }
        this.checkProcessEffectDate(process);
        return this.startProcess(process, startProcessInfo, startProcessInfo.getVariables());
    }

    @Override
    public ProcessInstance startProcessById(long processId, StartProcessInfo startProcessInfo) {
        ProcessDefinition process = this.getProcessById(processId);
        if (process == null) {
            throw new IllegalArgumentException("Process definition [" + processId + "] was not exist!");
        }
        this.checkProcessEffectDate(process);
        return this.startProcess(process, startProcessInfo, startProcessInfo.getVariables());
    }

    private void checkProcessEffectDate(ProcessDefinition process) {
        Date effectDate = process.getEffectDate();
        if (effectDate == null) {
            return;
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (effectDate.getTime() > new Date().getTime()) {
            throw new IllegalStateException("Process definition " + process.getName() + " effect date is " + sd.format(effectDate) + ".");
        }
    }

    @Override
    public ProcessInstance startProcessByName(String processName, StartProcessInfo startProcessInfo) {
        ProcessDefinition process = this.getProcessByName(processName);
        if (process == null) {
            throw new IllegalArgumentException("Process definition [" + processName + "] was not exist!");
        }
        this.checkProcessEffectDate(process);
        return this.startProcess(process, startProcessInfo, startProcessInfo.getVariables());
    }

    private ProcessInstance startProcess(ProcessDefinition process, StartProcessInfo startProcessInfo, Map<String, Object> variables) {
        return this.commandService.executeCommand(new StartProcessInstanceCommand(process, variables, startProcessInfo, 0L));
    }

    @Override
    public ProcessInstance startProcessByName(String processName, StartProcessInfo startProcessInfo, int version) {
        ProcessDefinition process = this.getProcessByName(processName, version);
        if (process == null) {
            throw new IllegalArgumentException("Process definition [" + processName + "-" + version + "] was not exist!");
        }
        this.checkProcessEffectDate(process);
        return this.startProcess(process, startProcessInfo, startProcessInfo.getVariables());
    }

    @Override
    public synchronized ProcessDefinition deployProcess(ZipInputStream zipInputStream) {
        return this.processDeployer.deploy(zipInputStream);
    }

    @Override
    public synchronized ProcessDefinition deployProcess(InputStream inputStream) {
        return this.processDeployer.deploy(inputStream);
    }

    @Override
    public ProcessDefinition deployProcess(InputStream inputStream, long processId) {
        CacheService cache = EnvironmentUtils.getEnvironment().getCache();
        int version = this.getProcessById(processId).getVersion();
        ProcessDefinition process = this.processDeployer.deploy(inputStream, version, processId);
        cache.putProcessDefinition(processId, process);
        this.doProcessInterceptors(process, true);
        return process;
    }

    @Override
    public synchronized ProcessInstance getProcessInstanceById(long processInstanceId) {
        return this.commandService.executeCommand(new GetProcessInstanceCommand(processInstanceId));
    }

    public void setProcessDeployer(ProcessDeployer processDeployer) {
        this.processDeployer = processDeployer;
    }

    public void setCommandService(CommandService commandService) {
        this.commandService = commandService;
    }

    @Override
    public void saveProcessVariable(long processInstanceId, String key, Object value) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put(key, value);
        this.saveProcessVariables(processInstanceId, variables);
    }

    @Override
    public void saveProcessVariables(long processInstanceId, Map<String, Object> variables) {
        ProcessInstance pi = this.getProcessInstanceById(processInstanceId);
        this.commandService.executeCommand(new SaveProcessInstanceVariablesCommand(pi, variables));
    }

    @Override
    public List<Variable> getProcessVariables(long processInstanceId) {
        ProcessVariableQueryImpl query = new ProcessVariableQueryImpl(this.commandService);
        query.processInstanceId(processInstanceId);
        return (List)query.list();
    }

    @Override
    public List<Variable> getProcessVariables(ProcessInstance processInstance) {
        ProcessVariableQueryImpl query = new ProcessVariableQueryImpl(this.commandService);
        query.rootprocessInstanceId(processInstance.getRootId());
        return (List)query.list();
    }

    @Override
    public Object getProcessVariable(String key, ProcessInstance processInstance) {
        Object obj = this.commandService.executeCommand(new GetExpressionValueCommand(processInstance.getId(), key));
        if (obj != null) {
            return obj;
        }
        Variable var = this.commandService.executeCommand(new GetProcessInstanceVariableCommand(key, processInstance));
        if (var != null) {
            return var.getValue();
        }
        return null;
    }

    @Override
    public Object getProcessVariable(String key, long processInstanceId) {
        Object obj = this.commandService.executeCommand(new GetExpressionValueCommand(processInstanceId, key));
        if (obj != null) {
            return obj;
        }
        ProcessInstance pi = this.getProcessInstanceById(processInstanceId);
        return this.getProcessVariable(key, pi);
    }

    @Override
    public void deleteProcessInstance(ProcessInstance processInstance) {
        this.commandService.executeCommand(new DeleteProcessInstanceCommand(processInstance));
    }

    @Override
    public void deleteProcessInstanceById(long processInstanceId) {
        this.deleteProcessInstance(this.getProcessInstanceById(processInstanceId));
    }

    @Override
    public ProcessInstanceQuery createProcessInstanceQuery() {
        return new ProcessInstanceQueryImpl(this.commandService);
    }

    @Override
    public ProcessVariableQuery createProcessVariableQuery() {
        return new ProcessVariableQueryImpl(this.commandService);
    }

    @Override
    public ProcessQuery createProcessQuery() {
        return new ProcessQueryImpl(this.commandService);
    }

    @Override
    public void deleteProcess(long processId) {
        ProcessDefinition processDefinition = this.getProcessById(processId);
        this.deleteProcess(processDefinition);
    }

    @Override
    public void deleteProcess(String processKey) {
        ProcessDefinition processDefinition = this.getProcessByKey(processKey);
        this.deleteProcess(processDefinition);
    }

    @Override
    public void updateProcessForMemory(long processId) {
        ProcessDefinition process = this.commandService.executeCommand(new GetProcessCommand(processId, null, 0, null));
        if (process != null) {
            CacheService cache = EnvironmentUtils.getEnvironment().getCache();
            cache.putProcessDefinition(process.getId(), process);
        }
    }

    @Override
    public void deleteProcess(ProcessDefinition processDefinition) {
        this.commandService.executeCommand(new DeleteProcessDefinitionCommand(processDefinition));
        CacheService cache = EnvironmentUtils.getEnvironment().getCache();
        cache.removeProcessDefinition(processDefinition.getId());
        this.doProcessInterceptors(processDefinition, false);
    }

    @Override
    public void deleteProcessFromMemory(long processId) {
        CacheService cache = EnvironmentUtils.getEnvironment().getCache();
        cache.removeProcessDefinition(processId);
    }

    @Override
    public void deleteProcessFromMemory(ProcessDefinition processDefinition) {
        CacheService cache = EnvironmentUtils.getEnvironment().getCache();
        cache.removeProcessDefinition(processDefinition.getId());
    }

    @Override
    public void deleteProcessFromMemory(String processKey) {
        ProcessDefinition processDefinition = this.getProcessByKey(processKey);
        CacheService cache = EnvironmentUtils.getEnvironment().getCache();
        cache.removeProcessDefinition(processDefinition.getId());
    }

    private void doProcessInterceptors(ProcessDefinition process, boolean update) {
        for (ProcessInterceptor interceptor : this.processInterceptors) {
            if (update) {
                interceptor.updateProcess(process);
                continue;
            }
            interceptor.deleteProcess(process);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.processInterceptors = applicationContext.getBeansOfType(ProcessInterceptor.class).values();
    }
}

