/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.service.impl;

import com.bstek.uflo.command.CommandService;
import com.bstek.uflo.command.impl.GetHistoryActivitiyCommand;
import com.bstek.uflo.command.impl.GetHistoryProcessInstanceCommand;
import com.bstek.uflo.command.impl.GetHistoryTaskCommand;
import com.bstek.uflo.command.impl.GetHistoryVariableCommand;
import com.bstek.uflo.command.impl.GetHistoryVariablesCommand;
import com.bstek.uflo.command.impl.GetListHistoryProcessInstancesCommand;
import com.bstek.uflo.command.impl.GetListHistoryTasksCommand;
import com.bstek.uflo.model.HistoryActivity;
import com.bstek.uflo.model.HistoryProcessInstance;
import com.bstek.uflo.model.HistoryTask;
import com.bstek.uflo.model.HistoryVariable;
import com.bstek.uflo.query.HistoryProcessInstanceQuery;
import com.bstek.uflo.query.HistoryProcessVariableQuery;
import com.bstek.uflo.query.HistoryTaskQuery;
import com.bstek.uflo.query.impl.HistoryProcessInstanceQueryImpl;
import com.bstek.uflo.query.impl.HistoryProcessVariableQueryImpl;
import com.bstek.uflo.query.impl.HistoryTaskQueryImpl;
import com.bstek.uflo.service.HistoryService;
import java.util.List;

public class DefaultHistoryService
implements HistoryService {
    private CommandService commandService;

    @Override
    public List<HistoryActivity> getHistoryActivitysByProcesssInstanceId(long processInstanceId) {
        return this.commandService.executeCommand(new GetHistoryActivitiyCommand(processInstanceId, true));
    }

    @Override
    public HistoryProcessVariableQuery createHistoryProcessVariableQuery() {
        return new HistoryProcessVariableQueryImpl(this.commandService);
    }

    @Override
    public HistoryVariable getHistoryVariable(long historyProcessInstanceId, String key) {
        return this.commandService.executeCommand(new GetHistoryVariableCommand(historyProcessInstanceId, key));
    }

    @Override
    public List<HistoryActivity> getHistoryActivitysByHistoryProcesssInstanceId(long historyProcessInstanceId) {
        return this.commandService.executeCommand(new GetHistoryActivitiyCommand(historyProcessInstanceId, false));
    }

    @Override
    public List<HistoryProcessInstance> getHistoryProcessInstances(long processId) {
        return this.commandService.executeCommand(new GetListHistoryProcessInstancesCommand(processId));
    }

    @Override
    public HistoryProcessInstance getHistoryProcessInstance(long processInstanceId) {
        return this.commandService.executeCommand(new GetHistoryProcessInstanceCommand(processInstanceId));
    }

    @Override
    public List<HistoryTask> getHistoryTasks(long processInstanceId) {
        return this.commandService.executeCommand(new GetListHistoryTasksCommand(processInstanceId));
    }

    @Override
    public HistoryProcessInstanceQuery createHistoryProcessInstanceQuery() {
        return new HistoryProcessInstanceQueryImpl(this.commandService);
    }

    @Override
    public HistoryTaskQuery createHistoryTaskQuery() {
        return new HistoryTaskQueryImpl(this.commandService);
    }

    @Override
    public List<HistoryVariable> getHistoryVariables(long historyProcessInstanceId) {
        return this.commandService.executeCommand(new GetHistoryVariablesCommand(historyProcessInstanceId));
    }

    @Override
    public HistoryTask getHistoryTask(long taskId) {
        return this.commandService.executeCommand(new GetHistoryTaskCommand(taskId));
    }

    public void setCommandService(CommandService commandService) {
        this.commandService = commandService;
    }
}

