/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.service.impl;

import com.bstek.uflo.command.CommandService;
import com.bstek.uflo.command.impl.GetAllCalendarDefCommand;
import com.bstek.uflo.command.impl.GetCalendarDateCommand;
import com.bstek.uflo.command.impl.GetCalendarDefCommand;
import com.bstek.uflo.model.calendar.CalendarDate;
import com.bstek.uflo.model.calendar.CalendarDef;
import com.bstek.uflo.model.calendar.CalendarType;
import com.bstek.uflo.process.node.calendar.WorkdayCalendar;
import com.bstek.uflo.service.CalendarService;
import java.util.Collection;
import java.util.GregorianCalendar;
import org.quartz.Calendar;
import org.quartz.impl.calendar.AnnualCalendar;
import org.quartz.impl.calendar.DailyCalendar;
import org.quartz.impl.calendar.HolidayCalendar;
import org.quartz.impl.calendar.MonthlyCalendar;
import org.quartz.impl.calendar.WeeklyCalendar;

public class CalendarServiceImpl
implements CalendarService {
    private CommandService commandService;

    @Override
    public Collection<CalendarDef> getAllCalendarDefs() {
        return this.commandService.executeCommand(new GetAllCalendarDefCommand());
    }

    @Override
    public CalendarDef getCalendarDef(long calendarId) {
        return this.commandService.executeCommand(new GetCalendarDefCommand(calendarId));
    }

    @Override
    public Collection<CalendarDate> getCalendarDate(long calendarId) {
        return this.commandService.executeCommand(new GetCalendarDateCommand(calendarId));
    }

    @Override
    public Calendar getCalendar(long calendarId) {
        CalendarDef def = this.getCalendarDef(calendarId);
        Collection<CalendarDate> dates = this.getCalendarDate(calendarId);
        Calendar baseCalendar = this.buildCalendar(def, dates);
        return baseCalendar;
    }

    private Calendar buildCalendar(CalendarDef calendarDef, Collection<CalendarDate> dates) {
        CalendarType type = calendarDef.getType();
        if (type.equals((Object)CalendarType.holiday)) {
            HolidayCalendar calendar = new HolidayCalendar();
            if (dates != null) {
                for (CalendarDate d : dates) {
                    calendar.addExcludedDate(d.getCalendarDate());
                }
            }
            return calendar;
        }
        if (type.equals((Object)CalendarType.workday)) {
            WorkdayCalendar calendar = new WorkdayCalendar();
            if (dates != null) {
                for (CalendarDate d : dates) {
                    calendar.addIncludedDate(d.getCalendarDate());
                }
            }
            return calendar;
        }
        if (type.equals((Object)CalendarType.annual)) {
            AnnualCalendar calendar = new AnnualCalendar();
            if (dates != null) {
                for (CalendarDate d : dates) {
                    GregorianCalendar c = new GregorianCalendar();
                    c.set(2, d.getMonthOfYear());
                    c.set(5, d.getDayOfMonth());
                    calendar.setDayExcluded((java.util.Calendar)c, true);
                }
            }
            return calendar;
        }
        if (type.equals((Object)CalendarType.monthly)) {
            MonthlyCalendar calendar = new MonthlyCalendar();
            if (dates != null) {
                for (CalendarDate d : dates) {
                    calendar.setDayExcluded(d.getDayOfMonth(), true);
                }
            }
            return calendar;
        }
        if (type.equals((Object)CalendarType.weekly)) {
            WeeklyCalendar calendar = new WeeklyCalendar();
            calendar.setDayExcluded(1, false);
            calendar.setDayExcluded(7, false);
            if (dates != null) {
                for (CalendarDate d : dates) {
                    calendar.setDayExcluded(d.getDayOfWeek(), true);
                }
            }
            return calendar;
        }
        if (type.equals((Object)CalendarType.daily) && dates != null) {
            DailyCalendar calendar = null;
            for (CalendarDate d : dates) {
                calendar = new DailyCalendar(calendar, d.getRangeStartTime(), d.getRangeEndTime());
            }
            return calendar;
        }
        return null;
    }

    public CommandService getCommandService() {
        return this.commandService;
    }

    public void setCommandService(CommandService commandService) {
        this.commandService = commandService;
    }
}

