/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.query.impl;

import com.bstek.uflo.command.CommandService;
import com.bstek.uflo.command.impl.QueryCountCommand;
import com.bstek.uflo.command.impl.QueryListCommand;
import com.bstek.uflo.model.task.Task;
import com.bstek.uflo.model.task.TaskState;
import com.bstek.uflo.model.task.TaskType;
import com.bstek.uflo.query.QueryJob;
import com.bstek.uflo.query.TaskQuery;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class TaskQueryImpl
implements TaskQuery,
QueryJob {
    private String url;
    private String businessId;
    private String owner;
    private long processInstanceId;
    private Date createDateLessThen;
    private Date createDateLessThenOrEquals;
    private Date createDateGreaterThen;
    private Date createDateGreaterThenOrEquals;
    private long rootProcessInstanceId;
    private Date dueDateLessThen;
    private Date dueDateLessThenOrEquals;
    private Date dueDateGreaterThen;
    private Date dueDateGreaterThenOrEquals;
    private Boolean countersign;
    private TaskType type;
    private String name;
    private String subject;
    private String nodeName;
    private Integer progress;
    private String priority;
    private int firstResult;
    private int maxResults;
    private List<TaskState> states = new ArrayList<TaskState>();
    private List<TaskState> prevstates = new ArrayList<TaskState>();
    private List<String> ascOrders = new ArrayList<String>();
    private List<String> descOrders = new ArrayList<String>();
    private List<String> participators = new ArrayList<String>();
    private List<String> assignees = new ArrayList<String>();
    private List<Long> processIds = new ArrayList<Long>();
    private CommandService commandService;

    public TaskQueryImpl(CommandService commandService) {
        this.commandService = commandService;
    }

    @Override
    public List<Task> list() {
        return (List)this.commandService.executeCommand(new QueryListCommand(this));
    }

    @Override
    public int count() {
        return this.commandService.executeCommand(new QueryCountCommand(this));
    }

    @Override
    public Criteria getCriteria(Session session, boolean queryCount) {
        Criteria criteria = session.createCriteria(Task.class);
        this.buildCriteria(criteria, queryCount);
        return criteria;
    }

    private void buildCriteria(Criteria criteria, boolean queryCount) {
        TaskState nextState;
        TaskState state;
        int i;
        LogicalExpression top;
        int size;
        if (!queryCount && this.firstResult > 0) {
            criteria.setFirstResult(this.firstResult);
        }
        if (!queryCount && this.maxResults > 0) {
            criteria.setMaxResults(this.maxResults);
        }
        if (this.processIds.size() > 0) {
            if (this.processIds.size() == 1) {
                long processId = this.processIds.get(0);
                criteria.add((Criterion)Restrictions.eq((String)"processId", (Object)processId));
            } else {
                criteria.add(Restrictions.in((String)"processId", this.processIds));
            }
        }
        if (StringUtils.isNotEmpty((String)this.owner)) {
            criteria.add((Criterion)Restrictions.eq((String)"owner", (Object)this.owner));
        }
        if (this.assignees.size() > 0) {
            if (this.assignees.size() == 1) {
                String assignee = this.assignees.get(0);
                criteria.add((Criterion)Restrictions.eq((String)"assignee", (Object)assignee));
            } else {
                criteria.add(Restrictions.in((String)"assignee", this.assignees));
            }
        }
        if (this.countersign != null) {
            criteria.add((Criterion)Restrictions.eq((String)"countersign", (Object)this.countersign));
        }
        if (this.type != null) {
            criteria.add((Criterion)Restrictions.eq((String)"type", (Object)((Object)this.type)));
        }
        if (this.processInstanceId > 0L) {
            criteria.add((Criterion)Restrictions.eq((String)"processInstanceId", (Object)this.processInstanceId));
        }
        if (this.rootProcessInstanceId > 0L) {
            criteria.add((Criterion)Restrictions.eq((String)"rootProcessInstanceId", (Object)this.rootProcessInstanceId));
        }
        if (StringUtils.isNotEmpty((String)this.url)) {
            criteria.add((Criterion)Restrictions.like((String)"url", (Object)this.url));
        }
        if (StringUtils.isNotEmpty((String)this.subject)) {
            criteria.add((Criterion)Restrictions.like((String)"subject", (Object)this.subject));
        }
        if (StringUtils.isNotEmpty((String)this.name)) {
            criteria.add((Criterion)Restrictions.like((String)"taskName", (Object)this.name));
        }
        if (StringUtils.isNotEmpty((String)this.nodeName)) {
            criteria.add((Criterion)Restrictions.eq((String)"nodeName", (Object)this.nodeName));
        }
        if (StringUtils.isNotEmpty((String)this.businessId)) {
            criteria.add((Criterion)Restrictions.eq((String)"businessId", (Object)this.businessId));
        }
        if (StringUtils.isNotEmpty((String)this.priority)) {
            criteria.add((Criterion)Restrictions.eq((String)"priority", (Object)this.priority));
        }
        if (this.progress != null) {
            criteria.add((Criterion)Restrictions.eq((String)"progress", (Object)this.progress));
        }
        if (this.createDateLessThen != null) {
            criteria.add((Criterion)Restrictions.lt((String)"createDate", (Object)this.createDateLessThen));
        }
        if (this.createDateGreaterThen != null) {
            criteria.add((Criterion)Restrictions.gt((String)"createDate", (Object)this.createDateGreaterThen));
        }
        if (this.createDateLessThenOrEquals != null) {
            criteria.add((Criterion)Restrictions.le((String)"createDate", (Object)this.createDateLessThenOrEquals));
        }
        if (this.createDateGreaterThenOrEquals != null) {
            criteria.add((Criterion)Restrictions.ge((String)"createDate", (Object)this.createDateGreaterThenOrEquals));
        }
        if (this.dueDateLessThen != null) {
            criteria.add((Criterion)Restrictions.lt((String)"duedate", (Object)this.dueDateLessThen));
        }
        if (this.dueDateGreaterThen != null) {
            criteria.add((Criterion)Restrictions.gt((String)"duedate", (Object)this.dueDateGreaterThen));
        }
        if (this.dueDateLessThenOrEquals != null) {
            criteria.add((Criterion)Restrictions.le((String)"duedate", (Object)this.dueDateLessThenOrEquals));
        }
        if (this.dueDateGreaterThenOrEquals != null) {
            criteria.add((Criterion)Restrictions.ge((String)"duedate", (Object)this.dueDateGreaterThenOrEquals));
        }
        if (!queryCount) {
            for (String ascProperty : this.ascOrders) {
                criteria.addOrder(Order.asc((String)ascProperty));
            }
            for (String descProperty : this.descOrders) {
                criteria.addOrder(Order.desc((String)descProperty));
            }
        }
        if ((size = this.states.size()) == 1) {
            criteria.add((Criterion)Restrictions.eq((String)"state", (Object)((Object)this.states.get(0))));
        } else if (size > 1) {
            top = null;
            for (i = 0; i < size; ++i) {
                state = this.states.get(i);
                if (top == null) {
                    nextState = this.states.get(++i);
                    top = Restrictions.or((Criterion)Restrictions.eq((String)"state", (Object)((Object)state)), (Criterion)Restrictions.eq((String)"state", (Object)((Object)nextState)));
                    continue;
                }
                top = Restrictions.or(top, (Criterion)Restrictions.eq((String)"state", (Object)((Object)state)));
            }
            criteria.add(top);
        }
        size = this.prevstates.size();
        if (size == 1) {
            criteria.add((Criterion)Restrictions.eq((String)"prevState", (Object)((Object)this.prevstates.get(0))));
        } else if (size > 1) {
            top = null;
            for (i = 0; i < size; ++i) {
                state = this.prevstates.get(i);
                if (top == null) {
                    nextState = this.prevstates.get(++i);
                    top = Restrictions.or((Criterion)Restrictions.eq((String)"prevState", (Object)((Object)state)), (Criterion)Restrictions.eq((String)"prevState", (Object)((Object)nextState)));
                    continue;
                }
                top = Restrictions.or((Criterion)top, (Criterion)Restrictions.eq((String)"prevState", (Object)((Object)state)));
            }
            criteria.add((Criterion)top);
        }
        if (this.participators.size() > 0) {
            Criteria participatorCriteria = criteria.createCriteria("taskParticipators");
            Disjunction disjunction = Restrictions.disjunction();
            for (String user : this.participators) {
                disjunction.add((Criterion)Restrictions.eq((String)"user", (Object)user));
            }
            participatorCriteria.add((Criterion)disjunction);
        }
    }

    @Override
    public TaskQuery addAssignee(String assignee) {
        this.assignees.add(assignee);
        return this;
    }

    @Override
    public TaskQuery businessId(String businessId) {
        this.businessId = businessId;
        return this;
    }

    @Override
    public TaskQuery addOrderAsc(String property) {
        this.ascOrders.add(property);
        return this;
    }

    @Override
    public TaskQuery addOrderDesc(String property) {
        this.descOrders.add(property);
        return this;
    }

    @Override
    public TaskQuery assignee(String assignee) {
        this.assignees.add(assignee);
        return this;
    }

    @Override
    public TaskQuery owner(String owner) {
        this.owner = owner;
        return this;
    }

    @Override
    public TaskQuery addTaskState(TaskState state) {
        this.states.add(state);
        return this;
    }

    @Override
    public TaskQuery addPrevTaskState(TaskState state) {
        this.prevstates.add(state);
        return this;
    }

    @Override
    public TaskQuery processInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public TaskQuery createDateLessThen(Date createDateLessThen) {
        this.createDateLessThen = createDateLessThen;
        return this;
    }

    @Override
    public TaskQuery createDateLessThenOrEquals(Date createDateLessThenOrEquals) {
        this.createDateLessThenOrEquals = createDateLessThenOrEquals;
        return this;
    }

    @Override
    public TaskQuery createDateGreaterThen(Date createDateGreaterThen) {
        this.createDateGreaterThen = createDateGreaterThen;
        return this;
    }

    @Override
    public TaskQuery createDateGreaterThenOrEquals(Date createDateGreaterThenOrEquals) {
        this.createDateGreaterThenOrEquals = createDateGreaterThenOrEquals;
        return this;
    }

    @Override
    public TaskQuery dueDateLessThen(Date dueDateLessThen) {
        this.dueDateLessThen = dueDateLessThen;
        return this;
    }

    @Override
    public TaskQuery dueDateLessThenOrEquals(Date dueDateLessThenOrEquals) {
        this.dueDateLessThenOrEquals = dueDateLessThenOrEquals;
        return this;
    }

    @Override
    public TaskQuery dueDateGreaterThen(Date dueDateGreaterThen) {
        this.dueDateGreaterThen = dueDateGreaterThen;
        return this;
    }

    @Override
    public TaskQuery dueDateGreaterThenOrEquals(Date dueDateGreaterThenOrEquals) {
        this.dueDateGreaterThenOrEquals = dueDateGreaterThenOrEquals;
        return this;
    }

    @Override
    public TaskQuery urlLike(String url) {
        this.url = url;
        return this;
    }

    @Override
    public TaskQuery subjectLike(String subject) {
        this.subject = subject;
        return this;
    }

    @Override
    public TaskQuery countersign(boolean countersign) {
        this.countersign = countersign;
        return this;
    }

    @Override
    public TaskQuery taskType(TaskType type) {
        this.type = type;
        return this;
    }

    @Override
    public TaskQuery addParticipator(String user) {
        this.participators.add(user);
        return this;
    }

    @Override
    public TaskQuery processId(long processId) {
        this.processIds.add(processId);
        return this;
    }

    @Override
    public TaskQuery addProcessId(long processId) {
        this.processIds.add(processId);
        return this;
    }

    @Override
    public TaskQuery rootProcessInstanceId(long rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
        return this;
    }

    @Override
    public TaskQuery nameLike(String name) {
        this.name = name;
        return this;
    }

    @Override
    public TaskQuery priority(String priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public TaskQuery progress(int progress) {
        this.progress = progress;
        return this;
    }

    @Override
    public TaskQuery nodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    @Override
    public TaskQuery page(int firstResult, int maxResults) {
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        return this;
    }
}

