/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.query.impl;

import com.bstek.uflo.command.CommandService;
import com.bstek.uflo.command.impl.QueryCountCommand;
import com.bstek.uflo.command.impl.QueryListCommand;
import com.bstek.uflo.model.ProcessDefinition;
import com.bstek.uflo.query.ProcessQuery;
import com.bstek.uflo.query.QueryJob;
import com.bstek.uflo.utils.EnvironmentUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class ProcessQueryImpl
implements ProcessQuery,
QueryJob {
    private long id;
    private String name;
    private String key;
    private String categoryId;
    private String category;
    private String subject;
    private int version;
    private int firstResult;
    private int maxResults;
    private Date createDateLessThen;
    private Date createDateLessThenOrEquals;
    private Date createDateGreaterThen;
    private Date createDateGreaterThenOrEquals;
    private List<String> ascOrders = new ArrayList<String>();
    private List<String> descOrders = new ArrayList<String>();
    private CommandService commandService;

    public ProcessQueryImpl(CommandService commandService) {
        this.commandService = commandService;
    }

    @Override
    public Criteria getCriteria(Session session, boolean queryCount) {
        Criteria criteria = session.createCriteria(ProcessDefinition.class);
        this.buildCriteria(criteria, queryCount);
        return criteria;
    }

    @Override
    public List<ProcessDefinition> list() {
        return (List)this.commandService.executeCommand(new QueryListCommand(this));
    }

    @Override
    public int count() {
        return this.commandService.executeCommand(new QueryCountCommand(this));
    }

    private void buildCriteria(Criteria criteria, boolean queryCount) {
        if (!queryCount && this.firstResult > 0) {
            criteria.setFirstResult(this.firstResult);
        }
        if (!queryCount && this.maxResults > 0) {
            criteria.setMaxResults(this.maxResults);
        }
        if (this.id > 0L) {
            criteria.add((Criterion)Restrictions.eq((String)"id", (Object)this.id));
        }
        if (StringUtils.isNotEmpty((String)this.name)) {
            criteria.add((Criterion)Restrictions.like((String)"name", (Object)this.name));
        }
        if (StringUtils.isNotEmpty((String)this.key)) {
            criteria.add((Criterion)Restrictions.like((String)"key", (Object)this.key));
        }
        if (StringUtils.isNotEmpty((String)this.subject)) {
            criteria.add((Criterion)Restrictions.like((String)"subject", (Object)this.subject));
        }
        if (this.createDateLessThen != null) {
            criteria.add((Criterion)Restrictions.lt((String)"createDate", (Object)this.createDateLessThen));
        }
        if (this.createDateGreaterThen != null) {
            criteria.add((Criterion)Restrictions.gt((String)"createDate", (Object)this.createDateGreaterThen));
        }
        if (this.createDateLessThenOrEquals != null) {
            criteria.add((Criterion)Restrictions.le((String)"createDate", (Object)this.createDateLessThenOrEquals));
        }
        if (this.createDateGreaterThenOrEquals != null) {
            criteria.add((Criterion)Restrictions.ge((String)"createDate", (Object)this.createDateGreaterThenOrEquals));
        }
        if (StringUtils.isNotEmpty((String)this.categoryId)) {
            criteria.add((Criterion)Restrictions.eq((String)"categoryId", (Object)this.categoryId));
        } else {
            this.categoryId = EnvironmentUtils.getEnvironment().getCategoryId();
            if (StringUtils.isNotEmpty((String)this.categoryId)) {
                criteria.add((Criterion)Restrictions.eq((String)"categoryId", (Object)this.categoryId));
            }
        }
        if (StringUtils.isNotBlank((String)this.category)) {
            criteria.add((Criterion)Restrictions.eq((String)"category", (Object)this.category));
        }
        if (this.version > 0) {
            criteria.add((Criterion)Restrictions.eq((String)"version", (Object)this.version));
        }
        if (!queryCount) {
            for (String ascProperty : this.ascOrders) {
                criteria.addOrder(Order.asc((String)ascProperty));
            }
            for (String descProperty : this.descOrders) {
                criteria.addOrder(Order.desc((String)descProperty));
            }
        }
    }

    @Override
    public ProcessQuery createDateGreaterThen(Date date) {
        this.createDateGreaterThen = date;
        return this;
    }

    @Override
    public ProcessQuery createDateGreaterThenOrEquals(Date date) {
        this.createDateGreaterThenOrEquals = date;
        return this;
    }

    @Override
    public ProcessQuery createDateLessThen(Date date) {
        this.createDateLessThen = date;
        return this;
    }

    @Override
    public ProcessQuery createDateLessThenOrEquals(Date date) {
        this.createDateLessThenOrEquals = date;
        return this;
    }

    @Override
    public ProcessQuery addOrderAsc(String property) {
        this.ascOrders.add(property);
        return this;
    }

    @Override
    public ProcessQuery addOrderDesc(String property) {
        this.descOrders.add(property);
        return this;
    }

    @Override
    public ProcessQuery id(long id) {
        this.id = id;
        return this;
    }

    @Override
    public ProcessQuery categoryId(String categoryId) {
        this.categoryId = categoryId;
        return this;
    }

    @Override
    public ProcessQuery category(String category) {
        this.category = category;
        return this;
    }

    @Override
    public ProcessQuery nameLike(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ProcessQuery subjectLike(String subject) {
        this.subject = subject;
        return this;
    }

    @Override
    public ProcessQuery keyLike(String key) {
        this.key = key;
        return this;
    }

    @Override
    public ProcessQuery version(int version) {
        this.version = version;
        return this;
    }

    @Override
    public ProcessQuery page(int firstResult, int maxResults) {
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        return this;
    }
}

