/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.query.impl;

import com.bstek.uflo.command.CommandService;
import com.bstek.uflo.command.impl.QueryCountCommand;
import com.bstek.uflo.command.impl.QueryListCommand;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.query.ProcessInstanceQuery;
import com.bstek.uflo.query.QueryJob;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class ProcessInstanceQueryImpl
implements ProcessInstanceQuery,
QueryJob {
    private long processId;
    private long parentId = -1L;
    private long rootId = -1L;
    private int firstResult;
    private int maxResults;
    private String businessId;
    private String promoter;
    private Date createDateLessThen;
    private Date createDateLessThenOrEquals;
    private Date createDateGreaterThen;
    private Date createDateGreaterThenOrEquals;
    private List<String> ascOrders = new ArrayList<String>();
    private List<String> descOrders = new ArrayList<String>();
    private CommandService commandService;

    public ProcessInstanceQueryImpl(CommandService commandService) {
        this.commandService = commandService;
    }

    @Override
    public Criteria getCriteria(Session session, boolean queryCount) {
        Criteria criteria = session.createCriteria(ProcessInstance.class);
        this.buildCriteria(criteria, queryCount);
        return criteria;
    }

    @Override
    public List<ProcessInstance> list() {
        return (List)this.commandService.executeCommand(new QueryListCommand(this));
    }

    @Override
    public ProcessInstanceQuery promoter(String promoter) {
        this.promoter = promoter;
        return this;
    }

    @Override
    public int count() {
        return this.commandService.executeCommand(new QueryCountCommand(this));
    }

    private void buildCriteria(Criteria criteria, boolean queryCount) {
        if (!queryCount && this.firstResult > 0) {
            criteria.setFirstResult(this.firstResult);
        }
        if (!queryCount && this.maxResults > 0) {
            criteria.setMaxResults(this.maxResults);
        }
        if (this.processId > 0L) {
            criteria.add((Criterion)Restrictions.eq((String)"processId", (Object)this.processId));
        }
        if (this.parentId > -1L) {
            criteria.add((Criterion)Restrictions.eq((String)"parentId", (Object)this.parentId));
        }
        if (this.rootId > -1L) {
            criteria.add((Criterion)Restrictions.eq((String)"rootId", (Object)this.rootId));
        }
        if (StringUtils.isNotEmpty((String)this.businessId)) {
            criteria.add((Criterion)Restrictions.eq((String)"businessId", (Object)this.businessId));
        }
        if (StringUtils.isNotEmpty((String)this.promoter)) {
            criteria.add((Criterion)Restrictions.eq((String)"promoter", (Object)this.promoter));
        }
        if (this.createDateLessThen != null) {
            criteria.add((Criterion)Restrictions.lt((String)"createDate", (Object)this.createDateLessThen));
        }
        if (this.createDateGreaterThen != null) {
            criteria.add((Criterion)Restrictions.gt((String)"createDate", (Object)this.createDateGreaterThen));
        }
        if (this.createDateLessThenOrEquals != null) {
            criteria.add((Criterion)Restrictions.le((String)"createDate", (Object)this.createDateLessThenOrEquals));
        }
        if (this.createDateGreaterThenOrEquals != null) {
            criteria.add((Criterion)Restrictions.ge((String)"createDate", (Object)this.createDateGreaterThenOrEquals));
        }
        if (!queryCount) {
            for (String ascProperty : this.ascOrders) {
                criteria.addOrder(Order.asc((String)ascProperty));
            }
            for (String descProperty : this.descOrders) {
                criteria.addOrder(Order.desc((String)descProperty));
            }
        }
    }

    @Override
    public ProcessInstanceQuery businessId(String businessId) {
        this.businessId = businessId;
        return this;
    }

    @Override
    public ProcessInstanceQuery processId(long processId) {
        this.processId = processId;
        return this;
    }

    @Override
    public ProcessInstanceQuery page(int firstResult, int maxResults) {
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        return this;
    }

    @Override
    public ProcessInstanceQuery addOrderAsc(String property) {
        this.ascOrders.add(property);
        return this;
    }

    @Override
    public ProcessInstanceQuery addOrderDesc(String property) {
        this.descOrders.add(property);
        return this;
    }

    @Override
    public ProcessInstanceQuery createDateLessThen(Date date) {
        this.createDateLessThen = date;
        return this;
    }

    @Override
    public ProcessInstanceQuery createDateLessThenOrEquals(Date date) {
        this.createDateLessThenOrEquals = date;
        return this;
    }

    @Override
    public ProcessInstanceQuery createDateGreaterThen(Date date) {
        this.createDateGreaterThen = date;
        return this;
    }

    @Override
    public ProcessInstanceQuery createDateGreaterThenOrEquals(Date date) {
        this.createDateGreaterThenOrEquals = date;
        return this;
    }

    @Override
    public ProcessInstanceQuery parentId(long parentId) {
        this.parentId = parentId;
        return this;
    }

    @Override
    public ProcessInstanceQuery rootId(long rootId) {
        this.rootId = rootId;
        return this;
    }
}

