/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.query.impl;

import com.bstek.uflo.command.CommandService;
import com.bstek.uflo.command.impl.QueryCountCommand;
import com.bstek.uflo.command.impl.QueryListCommand;
import com.bstek.uflo.model.HistoryTask;
import com.bstek.uflo.model.task.TaskState;
import com.bstek.uflo.model.task.TaskType;
import com.bstek.uflo.query.HistoryTaskQuery;
import com.bstek.uflo.query.QueryJob;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class HistoryTaskQueryImpl
implements HistoryTaskQuery,
QueryJob {
    private String url;
    private String assignee;
    private String owner;
    private String businessId;
    private long processInstanceId;
    private long historyProcessInstanceId;
    private long rootProcessInstanceId;
    private Date createDateLessThen;
    private Date createDateLessThenOrEquals;
    private Date createDateGreaterThen;
    private Date createDateGreaterThenOrEquals;
    private Date endDateLessThen;
    private Date endDateLessThenOrEquals;
    private Date endDateGreaterThen;
    private Date endDateGreaterThenOrEquals;
    private Boolean countersign;
    private TaskType type;
    private long processId;
    private long taskId;
    private String name;
    private String nodeName;
    private int firstResult;
    private int maxResults;
    private List<TaskState> states = new ArrayList<TaskState>();
    private List<TaskState> prevstates = new ArrayList<TaskState>();
    private List<String> ascOrders = new ArrayList<String>();
    private List<String> descOrders = new ArrayList<String>();
    private CommandService commandService;

    public HistoryTaskQueryImpl(CommandService commandService) {
        this.commandService = commandService;
    }

    @Override
    public List<HistoryTask> list() {
        return (List)this.commandService.executeCommand(new QueryListCommand(this));
    }

    @Override
    public int count() {
        return this.commandService.executeCommand(new QueryCountCommand(this));
    }

    @Override
    public Criteria getCriteria(Session session, boolean queryCount) {
        Criteria criteria = session.createCriteria(HistoryTask.class);
        this.buildCriteria(criteria, queryCount);
        return criteria;
    }

    private void buildCriteria(Criteria criteria, boolean queryCount) {
        if (!queryCount && this.firstResult > 0) {
            criteria.setFirstResult(this.firstResult);
        }
        if (!queryCount && this.maxResults > 0) {
            criteria.setMaxResults(this.maxResults);
        }
        if (this.processId > 0L) {
            criteria.add((Criterion)Restrictions.eq((String)"processId", (Object)this.processId));
        }
        if (StringUtils.isNotEmpty((String)this.owner)) {
            criteria.add((Criterion)Restrictions.eq((String)"owner", (Object)this.owner));
        }
        if (StringUtils.isNotEmpty((String)this.businessId)) {
            criteria.add((Criterion)Restrictions.eq((String)"businessId", (Object)this.businessId));
        }
        if (StringUtils.isNotEmpty((String)this.assignee)) {
            criteria.add((Criterion)Restrictions.eq((String)"assignee", (Object)this.assignee));
        }
        if (this.countersign != null) {
            criteria.add((Criterion)Restrictions.eq((String)"countersign", (Object)this.countersign));
        }
        if (this.type != null) {
            criteria.add((Criterion)Restrictions.eq((String)"type", (Object)((Object)this.type)));
        }
        if (this.processInstanceId > 0L) {
            criteria.add((Criterion)Restrictions.eq((String)"processInstanceId", (Object)this.processInstanceId));
        }
        if (this.rootProcessInstanceId > 0L) {
            criteria.add((Criterion)Restrictions.eq((String)"rootProcessInstanceId", (Object)this.rootProcessInstanceId));
        }
        if (this.taskId > 0L) {
            criteria.add((Criterion)Restrictions.eq((String)"taskId", (Object)this.taskId));
        }
        if (this.historyProcessInstanceId > 0L) {
            criteria.add((Criterion)Restrictions.eq((String)"historyProcessInstanceId", (Object)this.historyProcessInstanceId));
        }
        if (StringUtils.isNotEmpty((String)this.url)) {
            criteria.add((Criterion)Restrictions.like((String)"url", (Object)this.url));
        }
        if (StringUtils.isNotEmpty((String)this.name)) {
            criteria.add((Criterion)Restrictions.like((String)"taskName", (Object)this.name));
        }
        if (StringUtils.isNotEmpty((String)this.nodeName)) {
            criteria.add((Criterion)Restrictions.like((String)"nodeName", (Object)this.nodeName));
        }
        if (this.createDateLessThen != null) {
            criteria.add((Criterion)Restrictions.lt((String)"createDate", (Object)this.createDateLessThen));
        }
        if (this.createDateGreaterThen != null) {
            criteria.add((Criterion)Restrictions.gt((String)"createDate", (Object)this.createDateGreaterThen));
        }
        if (this.createDateLessThenOrEquals != null) {
            criteria.add((Criterion)Restrictions.le((String)"createDate", (Object)this.createDateLessThenOrEquals));
        }
        if (this.createDateGreaterThenOrEquals != null) {
            criteria.add((Criterion)Restrictions.ge((String)"createDate", (Object)this.createDateGreaterThenOrEquals));
        }
        if (this.endDateLessThen != null) {
            criteria.add((Criterion)Restrictions.lt((String)"endDate", (Object)this.endDateLessThen));
        }
        if (this.endDateGreaterThen != null) {
            criteria.add((Criterion)Restrictions.gt((String)"endDate", (Object)this.endDateGreaterThen));
        }
        if (this.endDateLessThenOrEquals != null) {
            criteria.add((Criterion)Restrictions.le((String)"endDate", (Object)this.endDateLessThenOrEquals));
        }
        if (this.endDateGreaterThenOrEquals != null) {
            criteria.add((Criterion)Restrictions.ge((String)"endDate", (Object)this.endDateGreaterThenOrEquals));
        }
        if (!queryCount) {
            for (String ascProperty : this.ascOrders) {
                criteria.addOrder(Order.asc((String)ascProperty));
            }
            for (String descProperty : this.descOrders) {
                criteria.addOrder(Order.desc((String)descProperty));
            }
        }
        for (TaskState state : this.states) {
            criteria.add((Criterion)Restrictions.eq((String)"state", (Object)((Object)state)));
        }
        for (TaskState state : this.prevstates) {
            criteria.add((Criterion)Restrictions.eq((String)"prevState", (Object)((Object)state)));
        }
    }

    @Override
    public HistoryTaskQuery addOrderAsc(String property) {
        this.ascOrders.add(property);
        return this;
    }

    @Override
    public HistoryTaskQuery addOrderDesc(String property) {
        this.descOrders.add(property);
        return this;
    }

    @Override
    public HistoryTaskQuery assignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    @Override
    public HistoryTaskQuery owner(String owner) {
        this.owner = owner;
        return this;
    }

    @Override
    public HistoryTaskQuery addTaskState(TaskState state) {
        this.states.add(state);
        return this;
    }

    @Override
    public HistoryTaskQuery addPrevTaskState(TaskState state) {
        this.prevstates.add(state);
        return this;
    }

    @Override
    public HistoryTaskQuery processInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public HistoryTaskQuery rootProcessInstanceId(long rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
        return this;
    }

    @Override
    public HistoryTaskQuery taskId(long taskId) {
        this.taskId = taskId;
        return this;
    }

    @Override
    public HistoryTaskQuery createDateLessThen(Date createDateLessThen) {
        this.createDateLessThen = createDateLessThen;
        return this;
    }

    @Override
    public HistoryTaskQuery createDateLessThenOrEquals(Date createDateLessThenOrEquals) {
        this.createDateLessThenOrEquals = createDateLessThenOrEquals;
        return this;
    }

    @Override
    public HistoryTaskQuery createDateGreaterThen(Date createDateGreaterThen) {
        this.createDateGreaterThen = createDateGreaterThen;
        return this;
    }

    @Override
    public HistoryTaskQuery createDateGreaterThenOrEquals(Date createDateGreaterThenOrEquals) {
        this.createDateGreaterThenOrEquals = createDateGreaterThenOrEquals;
        return this;
    }

    @Override
    public HistoryTaskQuery endDateLessThen(Date endDateLessThen) {
        this.endDateLessThen = endDateLessThen;
        return this;
    }

    @Override
    public HistoryTaskQuery endDateLessThenOrEquals(Date endDateLessThenOrEquals) {
        this.endDateLessThenOrEquals = endDateLessThenOrEquals;
        return this;
    }

    @Override
    public HistoryTaskQuery endDateGreaterThen(Date endDateGreaterThen) {
        this.endDateGreaterThen = endDateGreaterThen;
        return this;
    }

    @Override
    public HistoryTaskQuery endDateGreaterThenOrEquals(Date endDateGreaterThenOrEquals) {
        this.endDateGreaterThenOrEquals = endDateGreaterThenOrEquals;
        return this;
    }

    @Override
    public HistoryTaskQuery urlLike(String url) {
        this.url = url;
        return this;
    }

    @Override
    public HistoryTaskQuery businessId(String businessId) {
        this.businessId = businessId;
        return this;
    }

    @Override
    public HistoryTaskQuery countersign(boolean countersign) {
        this.countersign = countersign;
        return this;
    }

    @Override
    public HistoryTaskQuery taskType(TaskType type) {
        this.type = type;
        return this;
    }

    @Override
    public HistoryTaskQuery processId(long processId) {
        this.processId = processId;
        return this;
    }

    @Override
    public HistoryTaskQuery historyProcessInstanceId(long historyProcessInstanceId) {
        this.historyProcessInstanceId = historyProcessInstanceId;
        return this;
    }

    @Override
    public HistoryTaskQuery nameLike(String name) {
        this.name = name;
        return this;
    }

    @Override
    public HistoryTaskQuery nodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    @Override
    public HistoryTaskQuery page(int firstResult, int maxResults) {
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        return this;
    }
}

