/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.query.impl;

import com.bstek.uflo.command.CommandService;
import com.bstek.uflo.command.impl.QueryCountCommand;
import com.bstek.uflo.command.impl.QueryListCommand;
import com.bstek.uflo.model.HistoryVariable;
import com.bstek.uflo.query.HistoryProcessVariableQuery;
import com.bstek.uflo.query.QueryJob;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class HistoryProcessVariableQueryImpl
implements QueryJob,
HistoryProcessVariableQuery {
    private long historyProcessInstanceId;
    private String key;
    private int firstResult;
    private int maxResults;
    private List<String> ascOrders = new ArrayList<String>();
    private List<String> descOrders = new ArrayList<String>();
    private CommandService commandService;

    public HistoryProcessVariableQueryImpl(CommandService commandService) {
        this.commandService = commandService;
    }

    @Override
    public Criteria getCriteria(Session session, boolean queryCount) {
        Criteria criteria = session.createCriteria(HistoryVariable.class);
        this.buildCriteria(criteria, queryCount);
        return criteria;
    }

    private void buildCriteria(Criteria criteria, boolean queryCount) {
        if (!queryCount && this.firstResult > 0) {
            criteria.setFirstResult(this.firstResult);
        }
        if (!queryCount && this.maxResults > 0) {
            criteria.setMaxResults(this.maxResults);
        }
        if (this.historyProcessInstanceId > 0L) {
            criteria.add((Criterion)Restrictions.eq((String)"historyProcessInstanceId", (Object)this.historyProcessInstanceId));
        }
        if (StringUtils.isNotEmpty((String)this.key)) {
            criteria.add((Criterion)Restrictions.eq((String)"key", (Object)this.key));
        }
        if (!queryCount) {
            for (String ascProperty : this.ascOrders) {
                criteria.addOrder(Order.asc((String)ascProperty));
            }
            for (String descProperty : this.descOrders) {
                criteria.addOrder(Order.desc((String)descProperty));
            }
        }
    }

    @Override
    public List<HistoryVariable> list() {
        return (List)this.commandService.executeCommand(new QueryListCommand(this));
    }

    @Override
    public int count() {
        return this.commandService.executeCommand(new QueryCountCommand(this));
    }

    @Override
    public HistoryProcessVariableQuery historyProcessInstanceId(long historyProcessInstanceId) {
        this.historyProcessInstanceId = historyProcessInstanceId;
        return this;
    }

    @Override
    public HistoryProcessVariableQuery key(String key) {
        this.key = key;
        return this;
    }

    @Override
    public HistoryProcessVariableQuery page(int firstResult, int maxResults) {
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        return this;
    }

    @Override
    public HistoryProcessVariableQuery addOrderAsc(String property) {
        this.ascOrders.add(property);
        return this;
    }

    @Override
    public HistoryProcessVariableQuery addOrderDesc(String property) {
        this.descOrders.add(property);
        return this;
    }
}

