/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.query.impl;

import com.bstek.uflo.command.CommandService;
import com.bstek.uflo.command.impl.QueryCountCommand;
import com.bstek.uflo.command.impl.QueryListCommand;
import com.bstek.uflo.model.HistoryProcessInstance;
import com.bstek.uflo.query.HistoryProcessInstanceQuery;
import com.bstek.uflo.query.QueryJob;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class HistoryProcessInstanceQueryImpl
implements HistoryProcessInstanceQuery,
QueryJob {
    private long processId;
    private int firstResult;
    private int maxResults;
    private String tag;
    private String promoter;
    private String businessId;
    private Date createDateLessThen;
    private Date createDateLessThenOrEquals;
    private Date createDateGreaterThen;
    private Date createDateGreaterThenOrEquals;
    private List<String> ascOrders = new ArrayList<String>();
    private List<String> descOrders = new ArrayList<String>();
    private CommandService commandService;

    public HistoryProcessInstanceQueryImpl(CommandService commandService) {
        this.commandService = commandService;
    }

    @Override
    public Criteria getCriteria(Session session, boolean queryCount) {
        Criteria criteria = session.createCriteria(HistoryProcessInstance.class);
        this.buildCriteria(criteria, queryCount);
        return criteria;
    }

    @Override
    public List<HistoryProcessInstance> list() {
        return (List)this.commandService.executeCommand(new QueryListCommand(this));
    }

    @Override
    public int count() {
        return this.commandService.executeCommand(new QueryCountCommand(this));
    }

    private void buildCriteria(Criteria criteria, boolean queryCount) {
        if (!queryCount && this.firstResult > 0) {
            criteria.setFirstResult(this.firstResult);
        }
        if (!queryCount && this.maxResults > 0) {
            criteria.setMaxResults(this.maxResults);
        }
        criteria.add(Restrictions.isNotNull((String)"endDate"));
        if (this.processId > 0L) {
            criteria.add((Criterion)Restrictions.eq((String)"processId", (Object)this.processId));
        }
        if (StringUtils.isNotEmpty((String)this.businessId)) {
            criteria.add((Criterion)Restrictions.eq((String)"businessId", (Object)this.businessId));
        }
        if (StringUtils.isNotEmpty((String)this.tag)) {
            criteria.add((Criterion)Restrictions.eq((String)"tag", (Object)this.tag));
        }
        if (StringUtils.isNotEmpty((String)this.promoter)) {
            criteria.add((Criterion)Restrictions.eq((String)"promoter", (Object)this.promoter));
        }
        if (this.createDateLessThen != null) {
            criteria.add((Criterion)Restrictions.lt((String)"createDate", (Object)this.createDateLessThen));
        }
        if (this.createDateGreaterThen != null) {
            criteria.add((Criterion)Restrictions.gt((String)"createDate", (Object)this.createDateGreaterThen));
        }
        if (this.createDateLessThenOrEquals != null) {
            criteria.add((Criterion)Restrictions.le((String)"createDate", (Object)this.createDateLessThenOrEquals));
        }
        if (this.createDateGreaterThenOrEquals != null) {
            criteria.add((Criterion)Restrictions.ge((String)"createDate", (Object)this.createDateGreaterThenOrEquals));
        }
        if (!queryCount) {
            for (String ascProperty : this.ascOrders) {
                criteria.addOrder(Order.asc((String)ascProperty));
            }
            for (String descProperty : this.descOrders) {
                criteria.addOrder(Order.desc((String)descProperty));
            }
        }
    }

    @Override
    public HistoryProcessInstanceQuery processId(long processId) {
        this.processId = processId;
        return this;
    }

    @Override
    public HistoryProcessInstanceQuery page(int firstResult, int maxResults) {
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        return this;
    }

    @Override
    public HistoryProcessInstanceQuery addOrderAsc(String property) {
        this.ascOrders.add(property);
        return this;
    }

    @Override
    public HistoryProcessInstanceQuery businessId(String businessId) {
        this.businessId = businessId;
        return this;
    }

    @Override
    public HistoryProcessInstanceQuery promoter(String promoter) {
        this.promoter = promoter;
        return this;
    }

    @Override
    public HistoryProcessInstanceQuery tag(String tag) {
        this.tag = tag;
        return this;
    }

    @Override
    public HistoryProcessInstanceQuery addOrderDesc(String property) {
        this.descOrders.add(property);
        return this;
    }

    @Override
    public HistoryProcessInstanceQuery createDateLessThen(Date date) {
        this.createDateLessThen = date;
        return this;
    }

    @Override
    public HistoryProcessInstanceQuery createDateLessThenOrEquals(Date date) {
        this.createDateLessThenOrEquals = date;
        return this;
    }

    @Override
    public HistoryProcessInstanceQuery createDateGreaterThen(Date date) {
        this.createDateGreaterThen = date;
        return this;
    }

    @Override
    public HistoryProcessInstanceQuery createDateGreaterThenOrEquals(Date date) {
        this.createDateGreaterThenOrEquals = date;
        return this;
    }
}

