/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.process.node.calendar;

import com.bstek.uflo.process.node.calendar.WorkdayCalendar;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.quartz.impl.calendar.BaseCalendar;
import org.quartz.impl.calendar.DailyCalendar;

public class MultipleCalendar
extends BaseCalendar {
    private static final long serialVersionUID = -4142756339211533719L;
    private List<WorkdayCalendar> workdayCalendars = new ArrayList<WorkdayCalendar>();
    private List<DailyCalendar> dailyCalendars = new ArrayList<DailyCalendar>();
    private List<BaseCalendar> calendars = new ArrayList<BaseCalendar>();

    public void addCalendar(BaseCalendar calendar) {
        if (calendar instanceof WorkdayCalendar) {
            this.workdayCalendars.add((WorkdayCalendar)calendar);
        } else if (calendar instanceof DailyCalendar) {
            this.dailyCalendars.add((DailyCalendar)calendar);
        } else {
            this.calendars.add(calendar);
        }
    }

    public boolean isTimeIncluded(long timeStamp) {
        for (WorkdayCalendar workdayCalendar : this.workdayCalendars) {
            if (!workdayCalendar.isTimeIncluded(timeStamp)) continue;
            for (DailyCalendar dc : this.dailyCalendars) {
                if (dc.isTimeIncluded(timeStamp)) continue;
                return false;
            }
            return true;
        }
        for (BaseCalendar baseCalendar : this.calendars) {
            if (baseCalendar.isTimeIncluded(timeStamp)) continue;
            return false;
        }
        for (DailyCalendar dailyCalendar : this.dailyCalendars) {
            if (dailyCalendar.isTimeIncluded(timeStamp)) continue;
            return false;
        }
        return true;
    }

    public long getNextIncludedTime(long timeStamp) {
        Calendar day = null;
        for (BaseCalendar baseCalendar : this.calendars) {
            timeStamp = baseCalendar.getNextIncludedTime(timeStamp);
            day = this.getStartOfDayJavaCalendar(timeStamp);
            while (!this.isTimeIncluded(day.getTime().getTime())) {
                day.add(5, 1);
            }
        }
        for (DailyCalendar dailyCalendar : this.dailyCalendars) {
            timeStamp = dailyCalendar.getNextIncludedTime(timeStamp);
            day = this.getStartOfDayJavaCalendar(timeStamp);
            while (!this.isTimeIncluded(day.getTime().getTime())) {
                day.add(5, 1);
            }
        }
        return day.getTime().getTime();
    }
}

